/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ResourceURIToVariable;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;

public class VariableBinding
extends StringBinding {
    Session session;

    public VariableBinding(Session session) {
        super(Datatypes.STRING);
        this.session = session;
    }

    public boolean isImmutable() {
        return true;
    }

    public Object create(String value) throws BindingException {
        if (this.session == null) {
            throw new BindingException("Cannot create Variable without a Session");
        }
        try {
            return this.session.sync((ReadInterface)new ResourceURIToVariable(value));
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public String getValue(Object o) throws BindingException {
        if (this.session == null) {
            throw new BindingException("Cannot create Variable without a Session");
        }
        if (!(o instanceof Variable)) {
            throw new BindingException("Not a variable");
        }
        Variable v = (Variable)o;
        try {
            return (String)this.session.sync((ReadInterface)new VariableURI(v));
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public void setValue(Object o, String newValue) throws BindingException {
        throw new BindingException("Cannot set URI to Variable. URI is immutable");
    }

    public boolean isInstance(Object obj) {
        return obj instanceof Variable;
    }
}

