/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.ObjectVariantBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.PropertyVariableMapRequest;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardGraphPropertyVariable
extends AbstractPropertyVariable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardGraphPropertyVariable.class);
    protected static final PropertyInfo NO_PROPERTY = new PropertyInfo(null, null, false, Collections.emptySet(), null, null, null, null, null, null, Collections.emptyMap(), null, false);
    public final Variable parent;
    public final Resource parentResource;
    public final PropertyInfo property;
    public final Resource represents;
    private transient int hash = 0;

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, VariableNode node, Resource property) throws DatabaseException {
        this(graph, parent, node, parent.getPossibleRepresents(graph), StandardGraphPropertyVariable.getPropertyInfo(graph, property));
    }

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, VariableNode node, Resource parentResource, Resource property) throws DatabaseException {
        this(graph, parent, node, parentResource, StandardGraphPropertyVariable.getPropertyInfo(graph, property));
    }

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, Resource property) throws DatabaseException {
        this(graph, parent, null, parent.getPossibleRepresents(graph), StandardGraphPropertyVariable.getPropertyInfo(graph, property));
    }

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, Resource parentResource, PropertyInfo property) throws DatabaseException {
        this(parent, null, parentResource, property, StandardGraphPropertyVariable.getPossibleRepresents(graph, parentResource, property.predicate));
    }

    public StandardGraphPropertyVariable(ReadGraph graph, Variable parent, VariableNode node, Resource parentResource, PropertyInfo property) throws DatabaseException {
        this(parent, node, parentResource, property, StandardGraphPropertyVariable.getPossibleRepresents(graph, parentResource, property.predicate));
    }

    private static PropertyInfo getPropertyInfo(ReadGraph graph, Resource property) throws DatabaseException {
        return property != null ? (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(property), (AsyncProcedure)TransientCacheAsyncListener.instance()) : NO_PROPERTY;
    }

    private static Resource getPossibleRepresents(ReadGraph graph, Resource parentResource, Resource predicate) throws DatabaseException {
        if (parentResource == null || predicate == null) {
            return null;
        }
        return graph.getPossibleObject(parentResource, predicate);
    }

    public boolean isAsserted() {
        return false;
    }

    public StandardGraphPropertyVariable(Variable parent, VariableNode node, Resource parentResource, PropertyInfo property, Resource represents) throws DatabaseException {
        super(node);
        assert (parent != null);
        this.parent = parent;
        this.property = property;
        this.parentResource = parentResource;
        this.represents = represents;
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        if (this.node != null) {
            return this.node.support.manager.getName(this.node.node);
        }
        return this.property.name;
    }

    @Override
    public String getPossibleLabel(ReadGraph graph) throws DatabaseException {
        return (String)graph.getPossibleRelatedValue2(this.property.predicate, ((Layer0)graph.getService(Layer0.class)).HasLabel, (Object)this.parent, (Binding)Bindings.STRING);
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        return (String)graph.getRelatedValue2(this.property.predicate, ((Layer0)graph.getService(Layer0.class)).HasLabel, (Object)this.parent, (Binding)Bindings.STRING);
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public PropertyInfo getPropertyInfo(ReadGraph graph) throws DatabaseException {
        return this.property;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        return (T)this.getValueAccessor(graph).getValue(graph, this);
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        if (binding instanceof ObjectVariantBinding) {
            return this.getValue(graph);
        }
        try {
            return (T)this.getValueAccessor(graph).getValue(graph, this, binding);
        }
        catch (PendingVariableException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MissingVariableValueException(t);
        }
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        if (this.represents == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + this.getPossibleURI(graph) + ").");
        }
        return this.represents;
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        return this.represents;
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.getValueAccessor((ReadGraph)graph).setValue(graph, this, value, binding);
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.getValueAccessor((ReadGraph)graph).setValue(graph, this, value);
    }

    @Override
    public Binding getDefaultBinding(ReadGraph graph) throws DatabaseException {
        return Layer0Utils.getDefaultBinding(graph, this);
    }

    @Override
    public Binding getPossibleDefaultBinding(ReadGraph graph) throws DatabaseException {
        return Layer0Utils.getPossibleDefaultBinding(graph, this);
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        Datatype type;
        try {
            type = this.getValueAccessor(graph).getDatatype(graph, this);
        }
        catch (Throwable t) {
            throw new MissingVariableValueException(t);
        }
        if (type == null) {
            String uri = this.getPossibleURI(graph);
            if (uri != null) {
                throw new DatabaseException("No data type for " + uri);
            }
            throw new DatabaseException("No data type for " + this.getIdentifier());
        }
        return type;
    }

    @Override
    public Datatype getPossibleDatatype(ReadGraph graph) throws DatabaseException {
        try {
            return this.getDatatype(graph);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public String getUnit(ReadGraph graph) throws DatabaseException {
        try {
            return Layer0Utils.getUnit(graph, this);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public Resource getPropertyResource(ReadGraph graph) {
        return this.property.predicate;
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return this.parentResource;
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map != null) {
            map.getVariables(graph, this, result);
        }
        return result.values();
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map == null) {
            return null;
        }
        try {
            return map.getVariable(graph, this, name);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return null;
        }
        try {
            return valueMap.getVariable(graph, this, name);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
        catch (Exception t) {
            LOGGER.error("getPossibleDomainProperty is implemented incorrectly, but returns null on Exception for backward compatibility. URI=" + this.getURI(graph) + ", name=" + name + ".", (Throwable)t);
            return null;
        }
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return properties;
        }
        return valueMap.getVariables(graph, this, properties);
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return Variables.getVariable(graph, graph.getURI(this.property.predicate));
    }

    @Override
    public Resource getPredicateResource(ReadGraph graph) throws DatabaseException {
        return this.property.predicate;
    }

    @Override
    public Resource getPossiblePredicateResource(ReadGraph graph) throws DatabaseException {
        return this.property.predicate;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 1;
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
            result = 31 * result + (this.property.predicate != null ? this.property.predicate.hashCode() : 0);
            result = 31 * result + (this.parentResource != null ? this.parentResource.hashCode() : 0);
            this.hash = result = 31 * result + (this.represents != null ? this.represents.hashCode() : 0);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardGraphPropertyVariable other = (StandardGraphPropertyVariable)obj;
        if (this.node != null ? !this.node.equals(other.node) : other.node != null) {
            return false;
        }
        if (this.property.predicate != null ? !this.property.predicate.equals(other.property.predicate) : other.property.predicate != null) {
            return false;
        }
        if (this.parentResource != null ? !this.parentResource.equals(other.parentResource) : other.parentResource != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(other.parent) : other.parent != null) {
            return false;
        }
        return !(this.represents != null ? !this.represents.equals(other.represents) : other.represents != null);
    }

    @Override
    protected Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    protected ValueAccessor getValueAccessor(ReadGraph graph) throws DatabaseException {
        if ((this.property == null || this.property == NO_PROPERTY) && this.parentResource == null) {
            return All.standardValueAccessor;
        }
        ValueAccessor accessor = this.property.valueAccessor;
        if (accessor != null) {
            return accessor;
        }
        System.err.println("No value accessor for " + this.getURI(graph));
        return All.standardValueAccessor;
    }

    protected VariableMap getPossibleChildVariableMap(ReadGraph graph) throws DatabaseException {
        if (this.represents == null) {
            return All.standardPropertyDomainChildren;
        }
        Resource domainChildren = Layer0.getInstance((ReadGraph)graph).domainChildren;
        return (VariableMap)graph.getPossibleRelatedValue2(this.represents, domainChildren, (Object)new StandardGraphPropertyVariable(graph, this, domainChildren));
    }

    protected VariableMap getPossiblePropertyVariableMap(ReadGraph graph) throws DatabaseException {
        if (this.property == null) {
            return All.standardPropertyDomainProperties;
        }
        if (this.property.predicate == null) {
            return null;
        }
        return (VariableMap)graph.syncRequest((Read)new PropertyVariableMapRequest(this.property.predicate), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        return this.property.classifications;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, String classification, Map<String, Variable> properties) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return properties;
        }
        return valueMap.getVariables(graph, this, classification, properties);
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph, String classification) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return Collections.emptyList();
        }
        Map<String, Variable> propertyMap = valueMap.getVariables(graph, this, classification, null);
        if (propertyMap == null || propertyMap.isEmpty()) {
            return Collections.emptyList();
        }
        return propertyMap.values();
    }
}

