/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import java.io.IOException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;

public class AuthorizationFilter
implements ContainerRequestFilter {
    private final String token;

    public AuthorizationFilter(String token) {
        this.token = token;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("SCLRESTServer-Bearer ")) {
            throw new NotAuthorizedException((Object)"Authorization header must be provided", new Object[0]);
        }
        String token = authorizationHeader.substring("SCLRESTServer-Bearer".length()).trim();
        try {
            this.validateToken(token);
        }
        catch (Exception exception) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private void validateToken(String token) throws Exception {
        if (!this.token.equals(token)) {
            throw new Exception("Wrong token!");
        }
    }
}

