/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetElement;
import org.simantics.spreadsheet.graph.SpreadsheetEngine;
import org.simantics.spreadsheet.graph.SpreadsheetLine;
import org.simantics.spreadsheet.graph.SpreadsheetTypeNode;
import org.simantics.spreadsheet.graph.SpreadsheetVisitor;

public class SpreadsheetLines
implements SpreadsheetElement<SpreadsheetLine, SpreadsheetEngine>,
SheetNode {
    private static final long serialVersionUID = -3615335969248723486L;
    private final int id;
    private SpreadsheetEngine parent;
    private String name;
    public Int2ObjectAVLTreeMap<SpreadsheetLines> nodes = new Int2ObjectAVLTreeMap();
    public Int2ObjectAVLTreeMap<SpreadsheetLine> lines = new Int2ObjectAVLTreeMap();
    public int[] keys;

    public SpreadsheetLines(SpreadsheetEngine parent, String name) {
        this.parent = parent;
        this.name = name;
        this.id = this.getEngine().getBook().getNewId(this);
    }

    public SpreadsheetEngine getEngine() {
        return this.parent;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map getChildren() {
        Int2ObjectAVLTreeMap result = new Int2ObjectAVLTreeMap();
        result.putAll(this.nodes);
        result.putAll(this.lines);
        return result;
    }

    public Map getProperties() {
        return Collections.singletonMap("typeURI", new SpreadsheetTypeNode("http://www.simantics.org/Spreadsheet-1.2/Lines"));
    }

    Object resolve(String[] parts, int index) {
        String part = parts[index];
        if (part.charAt(0) == 'R') {
            int indx = Integer.parseInt(part.substring(3));
            SpreadsheetLine line = (SpreadsheetLine)this.lines.get(-indx);
            if (line != null) {
                if (index == parts.length - 1) {
                    return line;
                }
                return line.resolve(parts, index + 1);
            }
        } else {
            int indx = Integer.parseInt(part);
            SpreadsheetLines node = (SpreadsheetLines)this.nodes.get(indx);
            if (node != null) {
                if (index == parts.length - 1) {
                    return node;
                }
                return node.resolve(parts, index + 1);
            }
        }
        return null;
    }

    public Object ensureSubprocess(String[] path, int index) {
        String name = path[index];
        int i = Integer.parseInt(name);
        SpreadsheetLines line = (SpreadsheetLines)this.nodes.get(i);
        if (line == null) {
            line = new SpreadsheetLines(this.parent, "" + i);
            this.nodes.put(i, (Object)line);
        }
        if (index == path.length - 1) {
            return line;
        }
        return line.ensureSubprocess(path, index + 1);
    }

    public void setKeys(int[] keys) {
        this.keys = keys;
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    public String getPath() {
        return "/" + this.parent.getName() + "/" + this.parent.lines.getName() + "/" + this.getName();
    }

    private int getKey(int index) {
        return this.keys[2 * index + 1];
    }

    private int getChild(int index) {
        return this.keys[2 * index];
    }

    public SpreadsheetLine getLine(int k) {
        int i = 1;
        int n = (this.keys.length - 1) / 2;
        while (i <= n && k > this.getKey(i - 1)) {
            ++i;
        }
        if (i <= n && k == this.getKey(i - 1)) {
            return (SpreadsheetLine)this.lines.get(-k);
        }
        int nodeName = this.getChild(i - 1);
        SpreadsheetLines node = (SpreadsheetLines)this.nodes.get(nodeName);
        if (node == null) {
            return null;
        }
        return node.getLine(k);
    }

    public int getMaxRow() {
        if (this.keys == null) {
            int maxRow = 0;
            for (SpreadsheetLines node : this.nodes.values()) {
                int row = node.getMaxRow();
                if (row <= maxRow) continue;
                maxRow = row;
            }
            return maxRow;
        }
        int largestChild = this.keys[this.keys.length - 1];
        if (largestChild > 0) {
            SpreadsheetLines child = (SpreadsheetLines)this.nodes.get(largestChild);
            return child.getMaxRow();
        }
        return this.keys[this.keys.length - 2];
    }

    @Override
    public Optional<SpreadsheetEngine> getParent() {
        return Optional.of(this.parent);
    }

    @Override
    public Collection<SpreadsheetLine> getSpreadsheetChildren() {
        return this.lines.values();
    }

    @Override
    public void remove(SpreadsheetLine child) {
        this.lines.remove(-child.row);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetLines other = (SpreadsheetLines)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

