/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetElement;
import org.simantics.spreadsheet.graph.SpreadsheetLine;
import org.simantics.spreadsheet.graph.SpreadsheetLines;
import org.simantics.spreadsheet.graph.SpreadsheetVisitor;
import org.simantics.spreadsheet.graph.parser.ast.AstRange;

public class SpreadsheetEngine
implements SpreadsheetElement,
SheetNode {
    private static final long serialVersionUID = -5246063647558595642L;
    private static final String LINES = "Lines";
    private final SpreadsheetBook book;
    private final String name;
    private final int id;
    public SpreadsheetLines lines;
    public transient Map<String, Object> rangeCache;

    public Map<String, Object> getRangeCache() {
        if (this.rangeCache == null) {
            this.rangeCache = new HashMap<String, Object>();
        }
        return this.rangeCache;
    }

    public Object getCachedRange(AstRange range) {
        if (range.sheetName != null) {
            return null;
        }
        return this.getRangeCache().get(String.valueOf(range.first) + ":" + range.second);
    }

    public void cacheRange(AstRange range, Object value) {
        if (range.sheetName != null) {
            return;
        }
        this.getRangeCache().put(String.valueOf(range.first) + ":" + range.second, value);
    }

    public SpreadsheetEngine(SpreadsheetBook book, String name) {
        this.book = book;
        this.name = name;
        this.id = book.getNewId(this);
        this.lines = new SpreadsheetLines(this, LINES);
    }

    public SpreadsheetBook getBook() {
        return this.book;
    }

    public int getId() {
        return this.id;
    }

    Object resolve(String[] parts, int index) {
        String part = parts[index];
        if (!part.equals(LINES)) {
            return null;
        }
        if (index == parts.length - 1) {
            return this.lines;
        }
        return this.lines.resolve(parts, index + 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, SheetNode> getChildren() {
        return Collections.singletonMap(LINES, this.lines);
    }

    public Map<String, SheetNode> getProperties() {
        return Collections.emptyMap();
    }

    public Object ensureSubprocess(String[] path, int index) {
        String name = path[index];
        if (!LINES.equals(name)) {
            throw new IllegalStateException();
        }
        if (index == path.length - 1) {
            return this.lines;
        }
        return this.lines.ensureSubprocess(path, index + 1);
    }

    public SpreadsheetLine getLine(int row) {
        assert (this.lines.nodes.size() == 1);
        SpreadsheetLines root = (SpreadsheetLines)this.lines.nodes.values().iterator().next();
        return root.getLine(row);
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    public Range actualRange(Range r) {
        if (r.isFullRows()) {
            SpreadsheetLines root = (SpreadsheetLines)this.lines.nodes.values().iterator().next();
            Range result = new Range(r);
            result.startRow = 0;
            result.endRow = root.getMaxRow();
            return result;
        }
        return r;
    }

    public Optional<SpreadsheetElement> getParent() {
        return Optional.of(this.book);
    }

    public List<SpreadsheetElement> getSpreadsheetChildren() {
        return Collections.singletonList(this.lines);
    }

    public void remove(SpreadsheetElement child) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.book == null ? 0 : this.book.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetEngine other = (SpreadsheetEngine)obj;
        if (this.book == null ? other.book != null : !this.book.equals(other.book)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

