/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.tests;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JApplet;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.actions.IReconnectAction;
import org.simantics.diagram.connection.actions.MoveAction;
import org.simantics.diagram.connection.actions.ReconnectLineAction;
import org.simantics.diagram.connection.rendering.ExampleConnectionStyle;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ArrowExampleLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainExampleLineEndStyle;
import org.simantics.diagram.connection.tests.actions.HighlightReconnectPointsAction;
import org.simantics.diagram.connection.tests.actions.NewTerminalAction;

public class TestApplet
extends JApplet {
    private static final long serialVersionUID = 6135978753249808640L;
    public static final double TOLERANCE = 1.0;
    RouteGraph rg;
    IRouteGraphRenderer renderer = new StyledRouteGraphRenderer(new ExampleConnectionStyle());
    double posX = 0.0;
    double posY = 0.0;
    double mouseX;
    double mouseY;
    IAction currentAction;

    public TestApplet() {
        this(new RouteGraph());
        RouteLine v = this.rg.addLine(false, 0.0);
        this.rg.link(TestApplet.addTerminal(this.rg, -100.0, -100.0, 1, PlainExampleLineEndStyle.INSTANCE), v);
        this.rg.link(TestApplet.addTerminal(this.rg, -100.0, 100.0, 1, PlainExampleLineEndStyle.INSTANCE), v);
        this.rg.link(TestApplet.addTerminal(this.rg, 100.0, -80.0, 1, ArrowExampleLineEndStyle.INSTANCE), v);
        this.rg.link(TestApplet.addTerminal(this.rg, 100.0, 100.0, 4, ArrowExampleLineEndStyle.INSTANCE), v);
    }

    public TestApplet(RouteGraph rg_) throws HeadlessException {
        this.rg = rg_;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    TestApplet.this.mouseX = (double)e.getX() - TestApplet.this.posX;
                    TestApplet.this.mouseY = (double)e.getY() - TestApplet.this.posY;
                    if (e.isAltDown()) {
                        TestApplet.this.currentAction = new NewTerminalAction(TestApplet.this.rg, TestApplet.this.mouseX, TestApplet.this.mouseY);
                        TestApplet.this.repaint();
                    } else if (TestApplet.this.currentAction instanceof NewTerminalAction) {
                        ((NewTerminalAction)TestApplet.this.currentAction).finish(TestApplet.this.mouseX, TestApplet.this.mouseY);
                        TestApplet.this.currentAction = null;
                        TestApplet.this.repaint();
                    } else if (TestApplet.this.currentAction instanceof HighlightReconnectPointsAction) {
                        TestApplet.this.currentAction = ReconnectLineAction.create(TestApplet.this.rg, TestApplet.this.mouseX, TestApplet.this.mouseY);
                        TestApplet.this.repaint();
                    } else if (TestApplet.this.currentAction instanceof IReconnectAction) {
                        ((IReconnectAction)TestApplet.this.currentAction).finish(TestApplet.this.mouseX, TestApplet.this.mouseY);
                        TestApplet.this.currentAction = null;
                        TestApplet.this.repaint();
                    } else {
                        TestApplet.this.currentAction = MoveAction.create(TestApplet.this.rg, TestApplet.this.mouseX, TestApplet.this.mouseY);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TestApplet.this.currentAction instanceof MoveAction) {
                    ((MoveAction)TestApplet.this.currentAction).finish(TestApplet.this.mouseX, TestApplet.this.mouseY);
                    TestApplet.this.currentAction = null;
                    TestApplet.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TestApplet.this.mouseX = (double)e.getX() - TestApplet.this.posX;
                TestApplet.this.mouseY = (double)e.getY() - TestApplet.this.posY;
                if (TestApplet.this.currentAction != null) {
                    TestApplet.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                TestApplet.this.mouseX = (double)e.getX() - TestApplet.this.posX;
                TestApplet.this.mouseY = (double)e.getY() - TestApplet.this.posY;
                if (TestApplet.this.currentAction != null) {
                    TestApplet.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object target = TestApplet.this.rg.pick(TestApplet.this.mouseX, TestApplet.this.mouseY, 1.0);
                if (e.getKeyCode() == 44) {
                    if (target instanceof RouteTerminal) {
                        RouteTerminal terminal = (RouteTerminal)target;
                        TestApplet.this.rg.rotate(terminal, -1);
                        TestApplet.this.repaint();
                    }
                } else if (e.getKeyCode() == 46) {
                    if (target instanceof RouteTerminal) {
                        RouteTerminal terminal = (RouteTerminal)target;
                        TestApplet.this.rg.rotate(terminal, 1);
                        TestApplet.this.repaint();
                    }
                } else if (e.getKeyCode() == 68) {
                    if (target instanceof RouteTerminal) {
                        RouteTerminal terminal = (RouteTerminal)target;
                        TestApplet.this.rg.toggleDirectLines(terminal);
                        TestApplet.this.repaint();
                    }
                } else if (e.getKeyCode() == 83) {
                    if (target instanceof RouteLine) {
                        RouteLine rLine = (RouteLine)target;
                        TestApplet.this.rg.split(rLine, rLine.isHorizontal() ? TestApplet.this.mouseX : TestApplet.this.mouseY);
                        TestApplet.this.repaint();
                    }
                } else if (e.getKeyCode() == 127) {
                    if (target instanceof RouteLine) {
                        RouteLine line = (RouteLine)target;
                        TestApplet.this.rg.merge(line);
                    } else if (target instanceof RouteLink) {
                        TestApplet.this.rg.deleteCorner((RouteLink)target);
                    } else if (target instanceof RouteTerminal) {
                        TestApplet.this.rg.remove((RouteTerminal)target);
                    }
                    TestApplet.this.repaint();
                } else if (e.getKeyCode() == 27) {
                    if (TestApplet.this.currentAction != null) {
                        TestApplet.this.currentAction = null;
                    }
                    TestApplet.this.repaint();
                } else if (e.getKeyCode() == 80) {
                    TestApplet.this.rg.print();
                } else if (e.getKeyCode() == 17) {
                    if (TestApplet.this.currentAction == null) {
                        TestApplet.this.currentAction = new HighlightReconnectPointsAction(TestApplet.this.rg);
                    }
                    TestApplet.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    if (TestApplet.this.currentAction instanceof HighlightReconnectPointsAction) {
                        TestApplet.this.currentAction = null;
                    }
                    TestApplet.this.repaint();
                }
            }
        });
    }

    private static RouteTerminal addTerminal(RouteGraph rg, double x, double y, int allowedDirections, ILineEndStyle style) {
        return rg.addTerminal(x, y, x - 20.0, y - 20.0, x + 20.0, y + 20.0, allowedDirections, style);
    }

    @Override
    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.posX = (double)this.getWidth() * 0.5;
        this.posY = (double)this.getHeight() * 0.5;
        g.translate(this.posX, this.posY);
        if (this.currentAction != null) {
            this.currentAction.render(g, this.renderer, this.mouseX, this.mouseY);
        } else {
            this.renderer.render(g, this.rg);
        }
    }
}

