/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TVarAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.KMetaVar;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public final class TVar
extends Type {
    public static final TVar[] EMPTY_ARRAY = new TVar[0];
    private Kind kind;

    TVar(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        if (this.kind instanceof KMetaVar) {
            this.kind = Kinds.canonical(this.kind);
        }
        return this.kind;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        if (this == var) {
            return replacement;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        return new TVarAst(context.getName(this));
    }

    @Override
    public boolean equals(Object obj) {
        while (obj instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)obj;
            if (metaVar.ref == null) {
                return false;
            }
            obj = metaVar.ref;
        }
        return this == obj;
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        TObjectIntHashMap<TVar> varHashCode = context.getVarHashCode();
        if (varHashCode != null && varHashCode.containsKey((Object)this)) {
            context.append(varHashCode.get((Object)this));
        } else {
            context.append(System.identityHashCode(this));
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        if (!vars.contains(this)) {
            vars.add(this);
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public Kind inferKind(Environment context) throws KindUnificationException {
        if (this.kind == null) {
            this.kind = Kinds.metaVar();
        }
        return this.kind;
    }

    @Override
    public boolean containsMetaVars() {
        return false;
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        b.append(context.getName(this));
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public boolean contains(TMetaVar other) {
        return false;
    }

    @Override
    public Type convertMetaVarsToVars() {
        return this;
    }

    @Override
    public void addPolarity(Polarity polarity) {
    }

    @Override
    public Type head() {
        return this;
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        return this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int hashCode(int hash) {
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        int i = 0;
        while (i < boundVars.length) {
            if (boundVars[i] == this) {
                hash = HashCodeUtils.updateWithPreprocessedValue(hash, BOUND_VAR_HASH);
                return HashCodeUtils.update(hash, i);
            }
            ++i;
        }
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int skeletonHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int skeletonHashCode(int hash) {
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        int i = 0;
        while (i < boundVars.length) {
            if (boundVars[i] == this) {
                hash = HashCodeUtils.updateWithPreprocessedValue(hash, BOUND_VAR_HASH);
                return HashCodeUtils.update(hash, i);
            }
            ++i;
        }
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public boolean equalsCanonical(Type other) {
        return this == other;
    }

    @Override
    public Kind getKind(Environment context) {
        return this.kind;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return EMPTY_ARRAY;
    }
}

