/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TApplyAst;
import org.simantics.scl.compiler.internal.types.ast.TListAst;
import org.simantics.scl.compiler.internal.types.ast.TTupleAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TMultiApply;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TApply
extends Type {
    public Type function;
    public Type parameter;

    public TApply(Type function, Type parameter) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (parameter == null) {
            throw new NullPointerException();
        }
        this.function = function;
        this.parameter = parameter;
    }

    private TApply create(Type function, Type parameter) {
        if (function == this.function && parameter == this.parameter) {
            return this;
        }
        return new TApply(function, parameter);
    }

    @Override
    public TApply replace(TVar var, Type replacement) {
        return this.create(this.function.replace(var, replacement), this.parameter.replace(var, replacement));
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        TMultiApply multiApply = Types.toMultiApply(this);
        Type function = multiApply.function;
        List<Type> parameters = multiApply.parameters;
        TypeAst ast = null;
        int parameterPos = 0;
        if (function instanceof TCon) {
            if (function == Types.LIST && parameters.size() >= 1) {
                ast = new TListAst(parameters.get(0).toTypeAst(context));
                parameterPos = 1;
            } else {
                TCon con = (TCon)function;
                if (con.module == "Builtin" && con.name.charAt(0) == '(') {
                    int tupleLength = con.name.length() - 2;
                    if (tupleLength > 0) {
                        ++tupleLength;
                    }
                    if (parameters.size() >= tupleLength) {
                        TypeAst[] components = new TypeAst[tupleLength];
                        int i = 0;
                        while (i < tupleLength) {
                            components[i] = parameters.get(i).toTypeAst(context);
                            ++i;
                        }
                        ast = new TTupleAst(components);
                        parameterPos = tupleLength;
                    }
                }
            }
        }
        if (ast == null) {
            ast = function.toTypeAst(context);
        }
        while (parameterPos < multiApply.parameters.size()) {
            ast = new TApplyAst(ast, parameters.get(parameterPos).toTypeAst(context));
            ++parameterPos;
        }
        return ast;
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(305419896);
        this.function.updateHashCode(context);
        this.parameter.updateHashCode(context);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.function.collectFreeVars(vars);
        this.parameter.collectFreeVars(vars);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.function.collectMetaVars(vars);
        this.parameter.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.function.collectMetaVars(vars);
        this.parameter.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.function.collectEffectMetaVars(vars);
        this.parameter.collectEffectMetaVars(vars);
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.function.contains(other) || this.parameter.contains(other);
    }

    @Override
    public Type convertMetaVarsToVars() {
        Type newFunction = this.function.convertMetaVarsToVars();
        Type newParameter = this.parameter.convertMetaVarsToVars();
        if (newFunction == this.function && newParameter == this.parameter) {
            return this;
        }
        return new TApply(newFunction, newParameter);
    }

    @Override
    public boolean isGround() {
        return this.function.isGround() && this.parameter.isGround();
    }

    @Override
    public void checkKind(Environment context, Kind requiredKind) throws KindUnificationException {
        Kind functionKind = this.function.inferKind(context);
        Kind parameterKind = this.parameter.inferKind(context);
        Kinds.unify(functionKind, Kinds.arrow(parameterKind, requiredKind));
    }

    @Override
    public Kind getKind(Environment context) {
        Kind functionKind = this.function.getKind(context);
        return Kinds.rangeOfArrow(functionKind);
    }

    @Override
    public boolean containsMetaVars() {
        return this.function.containsMetaVars() || this.parameter.containsMetaVars();
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.function.toName(context, b);
        b.append('_');
        this.parameter.toName(context, b);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.function.addPolarity(Polarity.BIPOLAR);
        this.parameter.addPolarity(Polarity.BIPOLAR);
    }

    @Override
    public Type head() {
        return this.function.head();
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        Type newFunction = this.function.copySkeleton(metaVarMap);
        Type newParameter = this.parameter.copySkeleton(metaVarMap);
        if (newFunction == this.function && newParameter == this.parameter) {
            return this;
        }
        return new TApply(newFunction, newParameter);
    }

    @Override
    public int hashCode(int hash) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, APPLY_HASH);
        hash = this.function.hashCode(hash);
        hash = this.parameter.hashCode(hash);
        return hash;
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, APPLY_HASH);
        hash = this.function.hashCode(hash, boundVars);
        hash = this.parameter.hashCode(hash, boundVars);
        return hash;
    }

    @Override
    public int skeletonHashCode(int hash) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, APPLY_HASH);
        hash = this.function.skeletonHashCode(hash);
        hash = this.parameter.skeletonHashCode(hash);
        return hash;
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, APPLY_HASH);
        hash = this.function.skeletonHashCode(hash, boundVars);
        hash = this.parameter.skeletonHashCode(hash, boundVars);
        return hash;
    }

    public Type getCanonicalFunction() {
        if (this.function instanceof TMetaVar) {
            this.function = this.function.canonical();
        }
        return this.function;
    }

    public Type getCanonicalParameter() {
        if (this.parameter instanceof TMetaVar) {
            this.parameter = this.parameter.canonical();
        }
        return this.parameter;
    }

    @Override
    public boolean equalsCanonical(Type other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(TApply.class)) {
            return false;
        }
        TApply apply = (TApply)other;
        return this.getCanonicalFunction().equalsCanonical(apply.getCanonicalFunction()) && this.getCanonicalParameter().equalsCanonical(apply.getCanonicalParameter());
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return new Type[]{Skeletons.canonicalSkeleton(this.function), Skeletons.canonicalSkeleton(this.parameter)};
    }
}

