/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;

public class ClassBuilder {
    ModuleBuilder moduleBuilder;
    String className;
    String superClassName;
    ClassVisitor classVisitor;
    ClassWriter classWriter;

    public ClassBuilder(ModuleBuilder moduleBuilder, int access, String className, String superClassName, String ... interfaces) {
        ClassBuilder.checkClassName(className);
        ClassBuilder.checkClassName(superClassName);
        this.moduleBuilder = moduleBuilder;
        this.className = className;
        this.superClassName = superClassName;
        this.classWriter = new ClassWriter(1);
        this.classVisitor = this.classWriter;
        this.classVisitor.visit(49, access, className, null, superClassName, interfaces);
    }

    public void setSourceFile(String fileName) {
        this.classVisitor.visitSource(fileName, null);
    }

    public MethodBuilder addMethod(int access, String methodName, TypeDesc ret, TypeDesc[] params) {
        TypeDesc[] typeDescArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc param = typeDescArray[n2];
            if (param.equals(TypeDesc.VOID)) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        MethodVisitor methodVisitor = this.classVisitor.visitMethod(access, methodName, MethodDesc.forArguments(ret, params).getDescriptor(), null, null);
        methodVisitor = this.augmentMethodVisitor(methodName, methodVisitor);
        return new MethodBuilder(this, this.moduleBuilder, (access & 8) != 0, methodVisitor, params);
    }

    private MethodVisitor augmentMethodVisitor(String methodName, MethodVisitor methodVisitor) {
        return methodVisitor;
    }

    public MethodBuilderBase addMethodBase(int access, String methodName, TypeDesc ret, TypeDesc[] params) {
        TypeDesc[] typeDescArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc param = typeDescArray[n2];
            if (param.equals(TypeDesc.VOID)) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        MethodVisitor methodVisitor = this.classVisitor.visitMethod(access, methodName, MethodDesc.forArguments(ret, params).getDescriptor(), null, null);
        methodVisitor = this.augmentMethodVisitor(methodName, methodVisitor);
        return new MethodBuilderBase(this, (access & 8) != 0, methodVisitor, params);
    }

    public void addAbstractMethod(int access, String methodName, TypeDesc ret, TypeDesc[] params) {
        TypeDesc[] typeDescArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc param = typeDescArray[n2];
            if (param.equals(TypeDesc.VOID)) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        MethodVisitor methodVisitor = this.classVisitor.visitMethod(access, methodName, MethodDesc.forArguments(ret, params).getDescriptor(), null, null);
        int i = 0;
        while (i < params.length) {
            methodVisitor.visitParameter("p" + i, 1);
            ++i;
        }
        methodVisitor.visitEnd();
    }

    public MethodBuilderBase addConstructorBase(int access, TypeDesc[] params) {
        return this.addMethodBase(access, "<init>", TypeDesc.VOID, params);
    }

    public MethodBuilder addConstructor(int access, TypeDesc[] params) {
        return this.addMethod(access, "<init>", TypeDesc.VOID, params);
    }

    public MethodBuilder addInitializer() {
        return this.addMethod(1, "<clinit>", TypeDesc.VOID, Constants.EMPTY_TYPEDESC_ARRAY);
    }

    public MethodBuilderBase addInitializerBase() {
        return this.addMethodBase(1, "<clinit>", TypeDesc.VOID, Constants.EMPTY_TYPEDESC_ARRAY);
    }

    public void addField(int access, String fieldName, TypeDesc type) {
        if (type.equals(TypeDesc.VOID)) {
            throw new IllegalArgumentException();
        }
        FieldVisitor fieldVisitor = this.classVisitor.visitField(access, fieldName, type.getDescriptor(), null, null);
        fieldVisitor.visitEnd();
    }

    public byte[] finishClass() {
        this.classVisitor.visitEnd();
        return this.classWriter.toByteArray();
    }

    public String getClassName() {
        return this.className;
    }

    public void addDefaultConstructor() {
        MethodVisitor methodVisitor = this.classVisitor.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superClassName, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public TypeDesc getType() {
        return TypeDesc.forClass(this.className);
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public static void checkClassName(String className) {
    }

    public ModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }
}

