/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.simantics.Simantics;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependenciesRelation;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.issues.common.DependencyIssueSynchronizer2;
import org.simantics.issues.common.DependencyIssueValidator2;
import org.simantics.issues.common.IssueSource;
import org.simantics.issues.common.IssueSourceUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.simulation.ontology.SimulationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyIssueSource2
implements IssueSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyIssueSource2.class);
    public static final boolean DEBUG = false;
    private Resource source;
    private Resource model;
    private Resource type;
    private Set<Resource> searchTypes;
    private Resource base;
    private Resource extensionFunction;
    private CopyOnWriteArraySet<Function2<ReadGraph, List<Resource>, Boolean>> listeners = new CopyOnWriteArraySet();
    private ConcurrentMap<Function2<ReadGraph, List<Resource>, Boolean>, ChangeListener> listenerMap = new ConcurrentHashMap<Function2<ReadGraph, List<Resource>, Boolean>, ChangeListener>();

    public DependencyIssueSource2(ReadGraph graph, Resource source) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        this.source = source;
        this.model = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(source, SimulationResource.getInstance((ReadGraph)graph).Model));
        this.extensionFunction = graph.getPossibleObject(source, IR.Sources_DependencyTracker_HasExtension);
        this.type = graph.getSingleObject(source, IR.Sources_DependencyTracker_HasType);
        HashSet<Resource> _searchTypes = new HashSet<Resource>();
        _searchTypes.addAll(graph.getObjects(source, IR.Sources_DependencyTracker_HasSearchType));
        _searchTypes.add(this.type);
        this.searchTypes = new HashSet<Resource>(_searchTypes);
        Resource baseFunction = graph.getSingleObject(source, IR.Sources_DependencyTracker_HasBaseFunction);
        this.base = (Resource)Functions.exec((RequestProcessor)graph, (Resource)baseFunction, (Object[])new Object[]{graph, graph.getSingleObject(source, L0.PartOf)});
    }

    private List<Resource> resourcesToCheck(ReadGraph graph, DependencyChanges event) throws DatabaseException {
        HashSet<Resource> depSet = new HashSet<Resource>();
        depSet.addAll(IssueSourceUtils.getChangedDependencies(graph, this.model, this.base, this.searchTypes, event));
        depSet.addAll(IssueSourceUtils.getChangedDependencies(graph, this.source, this.model, this.base, this.searchTypes));
        List deps = new ArrayList(depSet);
        if (this.extensionFunction != null) {
            try {
                deps = (List)Functions.exec((RequestProcessor)graph, (Resource)this.extensionFunction, (Object[])new Object[]{graph, deps});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource dep : deps) {
            Set types = graph.getTypes(dep);
            if (!types.isEmpty() && !types.contains(this.type)) continue;
            result.add(dep);
        }
        return result;
    }

    @Override
    public void addDirtyListener(Function2<ReadGraph, List<Resource>, Boolean> runnable) {
        boolean added = this.listeners.add(runnable);
        if (added) {
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)Simantics.getSession().getService(GraphChangeListenerSupport.class);
            DependencyChangeListener metadataListener = new DependencyChangeListener();
            this.listenerMap.put(runnable, (ChangeListener)metadataListener);
            changeSupport.addMetadataListener((ChangeListener)metadataListener);
        }
    }

    @Override
    public void removeDirtyListener(Function2<ReadGraph, List<Resource>, Boolean> runnable) {
        boolean removed = this.listeners.remove(runnable);
        ChangeListener metadataListener = (ChangeListener)this.listenerMap.remove(runnable);
        if (removed && metadataListener != null) {
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)Simantics.getSession().getService(GraphChangeListenerSupport.class);
            changeSupport.removeMetadataListener(metadataListener);
        }
    }

    @Override
    public void update(WriteGraph graph, List<Resource> resources) throws DatabaseException {
        for (Resource resource : resources) {
            if (((Boolean)graph.syncRequest((Read)new DependencyIssueValidator2(resource, this.model, this.source), (Listener)TransientCacheListener.instance())).booleanValue()) continue;
            new DependencyIssueSynchronizer2(resource, this.source).perform(graph);
        }
        IssueSourceUtils.update(graph, this.source);
    }

    @Override
    public boolean needUpdate(ReadGraph graph, List<Resource> resources) throws DatabaseException {
        for (Resource resource : resources) {
            if (((Boolean)graph.syncRequest((Read)new DependencyIssueValidator2(resource, this.model, this.source), (Listener)TransientCacheListener.instance())).booleanValue()) continue;
            return true;
        }
        return false;
    }

    class DependencyChangeListener
    extends GenericChangeListener<DependenciesRelation.DependencyChangesRequest, DependencyChanges> {
        DependencyChangeListener() {
        }

        private boolean isValid(ReadGraph graph, List<Resource> toCheck) throws DatabaseException {
            for (Resource resource : toCheck) {
                if (((Boolean)graph.syncRequest((Read)new DependencyIssueValidator2(resource, DependencyIssueSource2.this.model, DependencyIssueSource2.this.source), (Listener)TransientCacheListener.instance())).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public boolean preEventRequest() {
            return !Indexing.isDependenciesIndexingDisabled();
        }

        public void onEvent(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
            List toCheck = DependencyIssueSource2.this.resourcesToCheck(graph, event);
            if (!this.isValid(graph, toCheck)) {
                for (Function2 r : DependencyIssueSource2.this.listeners) {
                    r.apply((Object)graph, (Object)toCheck);
                }
            }
            if (graph instanceof WriteGraph) {
                IssueSourceUtils.update((WriteGraph)graph, DependencyIssueSource2.this.source);
            }
        }
    }
}

