/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser2.label;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.request.PossibleVariableValue;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.ModelContexts;
import org.simantics.modeling.subscription.ModelContextsRequest;

public class SubscriptionItemLabelDecorationRule
implements LabelDecorationRule {
    public static final SubscriptionItemLabelDecorationRule INSTANCE = new SubscriptionItemLabelDecorationRule();
    private static final ColorDescriptor RED = ColorDescriptor.createFrom((RGB)new RGB(255, 0, 0));
    private static final ColorDescriptor INVALID = ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128));
    private static final ColorDescriptor GREEN = ColorDescriptor.createFrom((RGB)new RGB(0, 160, 0));
    static LabelDecorator RED_DECO = new LabelDecorator.Stub(){

        public <C> C decorateForeground(C color, String column, int itemIndex) {
            return (C)RED;
        }
    };
    static LabelDecorator GREEN_DECO = new LabelDecorator.Stub(){

        public <C> C decorateForeground(C color, String column, int itemIndex) {
            return (C)GREEN;
        }
    };
    static LabelDecorator UNRESOLVABLE = new LabelDecorator.Stub(){

        public String decorateLabel(String label, String column, int itemIndex) {
            return String.valueOf(label) + " (INVALID)";
        }

        public <C> C decorateForeground(C color, String column, int itemIndex) {
            return (C)INVALID;
        }

        public <F> F decorateFont(F font, String column, int itemIndex) {
            return (F)((FontDescriptor)font).withStyle(2);
        }
    };

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource item = (Resource)content;
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        RVI rvi = (RVI)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_VariableId, rviBinding);
        if (rvi == null) {
            return null;
        }
        Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(item));
        if (model == null) {
            return null;
        }
        ModelContexts contexts = (ModelContexts)graph.syncRequest((Read)new ModelContextsRequest(model));
        if (contexts.getExperimentContext() == null) {
            return null;
        }
        Variable variable = rvi.resolvePossible(graph, contexts.getExperimentContext());
        if (variable == null) {
            return UNRESOLVABLE;
        }
        Datatype datatype = (Datatype)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Datatype, Bindings.getBindingUnchecked(Datatype.class));
        if (!(datatype instanceof BooleanType)) {
            return null;
        }
        Object value = graph.sync((ReadInterface)new PossibleVariableValue(variable));
        if (!(value instanceof Boolean)) {
            return null;
        }
        Boolean v = (Boolean)value;
        return v != false ? GREEN_DECO : RED_DECO;
    }
}

