/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenDiagramAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.modeling.ui.plainDiagramEditor";

    public OpenDiagramAdapter() {
        super("Diagram Editor", Activator.COMPOSITE_ICON);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, DiagramResource.getInstance((ReadGraph)g).Diagram);
    }

    public void openEditor(final Resource r) throws Exception {
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                final Resource model = (Resource)g.sync((ReadInterface)new PossibleModel(r));
                if (model == null) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String editorId = OpenDiagramAdapter.this.getEditorId();
                            WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, r, model, null));
                        }
                        catch (PartInitException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                });
            }
        });
    }
}

