/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.utils.threads.ThreadUtils;

class Updater
implements Runnable {
    private static Updater INSTANCE;
    Map<INode, ICanvasContext> requesters = new HashMap<INode, ICanvasContext>();
    AtomicBoolean state = new AtomicBoolean(false);
    private static long time;

    static {
        time = System.nanoTime();
    }

    private Updater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<INode, ICanvasContext> map = this.requesters;
        synchronized (map) {
            if (this.requesters.isEmpty()) {
                this.state.set(false);
                throw new RuntimeException();
            }
        }
        ThreadUtils.AWT_EDT.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                time = System.nanoTime();
                Map<INode, ICanvasContext> map = Updater.this.requesters;
                synchronized (map) {
                    HashSet<ICanvasContext> ctxSet = new HashSet<ICanvasContext>();
                    for (ICanvasContext ctx : Updater.this.requesters.values()) {
                        if (ctx == null || !ctxSet.add(ctx)) continue;
                        ctx.getContentContext().setDirty();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(INode node) {
        Map<INode, ICanvasContext> map = this.requesters;
        synchronized (map) {
            if (this.requesters.size() == 0 && this.state.compareAndSet(false, true)) {
                ThreadUtils.getNonBlockingWorkExecutor().scheduleAtFixedRate(this, 0L, 500L, TimeUnit.MILLISECONDS);
            }
            ICanvasContext context = DiagramNodeUtil.getPossibleCanvasContext((IG2DNode)((G2DNode)node));
            this.requesters.put(node, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(INode node) {
        Map<INode, ICanvasContext> map = this.requesters;
        synchronized (map) {
            this.requesters.remove(node);
        }
    }

    public long getTime() {
        return time;
    }

    public static Updater getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Updater();
        }
        return INSTANCE;
    }
}

