/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scenegraph.profile.common.ObserverGroupValueListener;
import org.simantics.scenegraph.profile.impl.DebugPolicy;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.utils.datastructures.Pair;

public abstract class StyleBase<Result>
implements Style {
    protected final Map<Tuple, Result> values = new ConcurrentHashMap<Tuple, Result>();
    private Map<Pair<Resource, Group>, ObserverGroupListener> listeners = new HashMap<Pair<Resource, Group>, ObserverGroupListener>();
    private final List<Resource> removals = new ArrayList<Resource>();

    public Result calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        Variable activeVariable = (Variable)graph.syncRequest((Read)new RuntimeDiagramVariableRequest(runtimeDiagram), (Listener)TransientCacheListener.instance());
        if (activeVariable == null) {
            return null;
        }
        return this.calculateStyle(graph, runtimeDiagram, entry, groupItem, activeVariable);
    }

    public Result calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem, Variable activeComposite) throws DatabaseException {
        return null;
    }

    public void styleResultChanged(Observer observer, Resource runtimeDiagram, Resource object, Result result) {
        if (result == null) {
            this.values.remove(new Tuple2((Object)runtimeDiagram, (Object)object));
        } else {
            this.values.put((Tuple)new Tuple2((Object)runtimeDiagram, (Object)object), result);
        }
        observer.update();
    }

    public void applyStyleForNode(EvaluationContext evaluationContext, INode node, Result result) {
    }

    public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, Result value) {
        INode node = map.getNode(item);
        if (node == null) {
            evaluationContext.update();
            return;
        }
        if (DebugPolicy.DEBUG_PROFILE_STYLE_APPLICATION) {
            System.out.println(this + ": applying style for item " + item + " and element " + node + " with result " + value);
        }
        this.applyStyleForNode(evaluationContext, node, value);
    }

    protected void cleanupStyleForNode(INode node) {
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        this.cleanupStyleForNode(node);
    }

    protected void cleanupStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item) {
        INode node = map.getNode(item);
        if (node != null) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                System.out.println(this + ".cleanupStyleForItem(" + item + " = " + node + ")");
            }
            this.cleanupStyleForNode(evaluationContext, node);
        }
    }

    public final void activate(RequestProcessor backend, Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer) {
        GroupListener listener = this.getListener(runtimeDiagram, group);
        if (listener == null || listener.isDisposed()) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                System.out.println("activate(" + runtimeDiagram + ", " + group + ", " + observer);
            }
            listener = new GroupListener(backend.getSession(), runtimeDiagram, entry, this, group, (Observer)observer);
            this.listeners.put((Pair<Resource, Group>)Pair.make((Object)runtimeDiagram, (Object)group), listener);
            group.trackItems(backend, runtimeDiagram, listener);
        }
        listener.addEntry(entry);
    }

    protected Object getIdentity(Resource entry) {
        return new Pair(this.getClass(), (Object)entry);
    }

    protected Read<Result> getStyleCalculationRequest(Resource runtimeDiagram, final Resource entry, Resource item) {
        return new TernaryRead<Object, Resource, Resource, Result>(this.getIdentity(entry), runtimeDiagram, item){

            public Result perform(ReadGraph graph) throws DatabaseException {
                boolean oldSynchronous = graph.getSynchronous();
                try {
                    graph.setSynchronous(false);
                    Object result = StyleBase.this.calculateStyle(graph, (Resource)this.parameter2, entry, (Resource)this.parameter3);
                    if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                        System.out.println(StyleBase.this + ": calculated style result for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)this.parameter3), (boolean)true) + ": " + result);
                    }
                    Object Result = result;
                    return Result;
                }
                finally {
                    graph.setSynchronous(oldSynchronous);
                }
            }
        };
    }

    protected Listener<Result> getStyleResultListener(ObserverGroupListener groupListener, final Resource item, Group group, Observer observer, final Resource runtimeDiagram) {
        return new ObserverGroupValueListener<Result>(groupListener, observer, group, item){

            public void execute(Result result) {
                if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                    System.out.println(StyleBase.this + ": style result changed for " + item + ": " + result);
                }
                StyleBase.this.styleResultChanged(this.observer, runtimeDiagram, item, result);
            }
        };
    }

    public final void deactivate(Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer) {
        ObserverGroupListener listener = this.getListener(runtimeDiagram, group);
        if (listener != null) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                System.out.println("deactivate(" + runtimeDiagram + ", " + group + ", " + observer);
            }
            IDiagram diagram = (IDiagram)observer.getConstant(ProfileKeys.DIAGRAM);
            listener.removeEntry(entry);
            if (!listener.hasEntries()) {
                listener.dispose();
                this.listeners.remove(Pair.make((Object)runtimeDiagram, (Object)group));
            }
            if (diagram != null) {
                this.cleanupItems(observer, diagram, listener.getItems().toArray());
                diagram = null;
            }
            observer.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply(Resource entry, Group group, EvaluationContext evaluationContext) {
        ICanvasContext context = (ICanvasContext)evaluationContext.getConstant(ProfileKeys.CANVAS);
        assert (context.getThreadAccess().currentThreadAccess());
        ObserverGroupListener listener = this.getListener(evaluationContext.getResource(), group);
        if (listener == null) {
            System.out.println(this + "(" + this.getClass().getSimpleName() + ") had no listener for " + evaluationContext.getResource() + " " + group);
            return;
        }
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        if (DebugPolicy.DEBUG_PROFILE_STYLE_APPLICATION) {
            System.out.println(this + ": applying style for items: " + listener.getItems());
        }
        if (!this.removals.isEmpty()) {
            Resource[] removed;
            List<Resource> list = this.removals;
            synchronized (list) {
                removed = this.removals.toArray(Resource.NONE);
                this.removals.clear();
            }
            Resource[] resourceArray = removed;
            int n = removed.length;
            int n2 = 0;
            while (n2 < n) {
                Resource item = resourceArray[n2];
                this.cleanupStyleForItem(evaluationContext, map, item);
                ++n2;
            }
        }
        for (Object item : listener.getItems()) {
            Result value = this.values.get(new Tuple2((Object)evaluationContext.getResource(), item));
            this.applyStyleForItem(evaluationContext, map, item, value);
        }
    }

    protected final void cleanupItems(final EvaluationContext evaluationContext, final IDiagram diagram, final Object[] items) {
        ICanvasContext context = (ICanvasContext)evaluationContext.getConstant(ProfileKeys.CANVAS);
        context.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (evaluationContext.isDisposed()) {
                    return;
                }
                DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
                if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                    System.out.println(this + ".cleanupItems(" + evaluationContext + ", " + diagram + ", " + Arrays.toString(items));
                }
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    StyleBase.this.cleanupStyleForItem(evaluationContext, map, item);
                    ++n2;
                }
            }
        });
    }

    private ObserverGroupListener getListener(Resource runtime, Group group) {
        return this.listeners.get(Pair.make((Object)runtime, (Object)group));
    }

    static class GroupListener<T>
    extends ObserverGroupListener {
        private StyleBase<T> style;
        private Session session;
        private Resource runtimeDiagram;
        private Resource entry;

        GroupListener(Session session, Resource runtimeDiagram, Resource entry, StyleBase<T> style, Group group, Observer observer) {
            super(style, group, observer);
            this.style = style;
            this.session = session;
            this.runtimeDiagram = runtimeDiagram;
            this.entry = entry;
        }

        public void add(Resource item) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                System.out.println(this.style + ": added to group " + this.group + ": " + item);
            }
            this.session.asyncRequest(this.style.getStyleCalculationRequest(this.runtimeDiagram, this.entry, item), this.style.getStyleResultListener(this, item, this.group, this.observer, this.runtimeDiagram));
            super.add(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Resource item) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                System.out.println(this.style + ": removed from group " + this.group + ": " + item);
            }
            List list = ((StyleBase)this.style).removals;
            synchronized (list) {
                ((StyleBase)this.style).removals.add(item);
            }
            super.remove(item);
        }
    }

    static class RuntimeDiagramVariableRequest
    extends UnaryRead<Resource, Variable> {
        public RuntimeDiagramVariableRequest(Resource runtimeDiagram) {
            super((Object)runtimeDiagram);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            String variableURI = (String)graph.getPossibleRelatedValue((Resource)this.parameter, DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
            if (variableURI == null) {
                return null;
            }
            Variable activeVariable = Variables.getPossibleVariable((ReadGraph)graph, (String)variableURI);
            return activeVariable;
        }
    }
}

