/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.profile.ElementTranslation;
import org.simantics.diagram.profile.MonitorTextGridResult;
import org.simantics.diagram.profile.TextGridStyle;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.utils.datastructures.Pair;

public class SCLTextGridStyle
extends TextGridStyle {
    final Resource style;
    final Font font;

    public SCLTextGridStyle(ReadGraph graph, Resource style) throws DatabaseException {
        this.style = style;
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        Resource fontR = graph.getPossibleObject(style, G2D.HasFont);
        this.font = fontR != null ? G2DUtils.getFont(graph, fontR) : null;
    }

    @Override
    protected Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return super.getFont();
    }

    @Override
    public Resource getPropertyRelation(ReadGraph graph, Resource module) {
        throw new Error("Fix this");
    }

    @Override
    protected Object getIdentity(Resource entry) {
        return new Pair((Object)this.style, (Object)entry);
    }

    @Override
    protected String rowId() {
        return this.getNodeName();
    }

    @Override
    public MonitorTextGridResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        String variableURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
        Variable activeVariable = Variables.getPossibleVariable((ReadGraph)graph, (String)variableURI);
        if (activeVariable == null) {
            return null;
        }
        Resource module = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (module == null) {
            return null;
        }
        Variable moduleVariable = activeVariable.browsePossible(graph, module);
        if (moduleVariable == null) {
            return null;
        }
        Variable styleVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.style);
        Function1 function = (Function1)styleVariable.getPossiblePropertyValue(graph, DIA.SCLTextGridStyle_texts);
        Tuple3 result = (Tuple3)Simantics.applySCLRead((ReadGraph)graph, (Function1)function, (Object)moduleVariable);
        AffineTransform transform = DiagramGraphUtil.getAffineTransform(graph, element);
        Vec2d offset = DiagramGraphUtil.getOffset(graph, element);
        boolean enabled = !DiagramGraphUtil.getProfileMonitorsHidden(graph, element);
        boolean up = DiagramGraphUtil.getProfileMonitorsUp(graph, element);
        double spacing = DiagramGraphUtil.getProfileMonitorSpacing(graph, element);
        return new MonitorTextGridResult(this.rowId(), (String)result.c0, (String)result.c1, (String)result.c2, enabled, up, spacing, null, null, ElementTranslation.function(element), transform, offset);
    }

    @Override
    public String getNodeName() {
        return "" + this.style.getResourceId();
    }
}

