/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.ElementFactoryAdapter;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;

public class SyncElementFactory
extends ElementFactoryAdapter {
    @Override
    public void create(AsyncReadGraph graph, final ICanvasContext canvas, final IDiagram diagram, final Resource elementType, AsyncProcedure<ElementClass> procedure) {
        graph.asyncRequest((Read)new UniqueRead<ElementClass>(){

            public ElementClass perform(ReadGraph graph) throws DatabaseException {
                return SyncElementFactory.this.create(graph, canvas, diagram, elementType);
            }
        }, procedure);
    }

    @Override
    public void load(AsyncReadGraph graph, final ICanvasContext canvas, final IDiagram diagram, final Resource elementResource, final IElement element, AsyncProcedure<IElement> procedure) {
        graph.asyncRequest((Read)new UniqueRead<IElement>(){

            public IElement perform(ReadGraph graph) throws DatabaseException {
                if (SyncElementFactory.this.isOk(graph, elementResource)) {
                    SyncElementFactory.this.load(graph, canvas, diagram, elementResource, element);
                }
                return element;
            }
        }, procedure);
    }

    public ElementClass create(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType) throws DatabaseException {
        throw new UnsupportedOperationException("This method should be implemented by subclass " + this.getClass().getName());
    }

    public boolean isOk(ReadGraph graph, Resource elementResource) throws DatabaseException {
        return graph.hasStatement(elementResource);
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementResource, IElement element) throws DatabaseException {
        throw new UnsupportedOperationException("This method should be implemented by subclass " + this.getClass().getName());
    }
}

