/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.simulation.ui.preferences.SimulationPreferences;

public final class SimulationPreferenceUtil {
    public static SimulationPreferences getDefaultPrefs() {
        return SimulationPreferenceUtil.getPrefs(DefaultScope.INSTANCE);
    }

    public static SimulationPreferences getPrefs() {
        return SimulationPreferenceUtil.getPrefs(InstanceScope.INSTANCE);
    }

    public static SimulationPreferences getPrefs(IScopeContext context) {
        IEclipsePreferences node = context.getNode("org.simantics.simulation.ui");
        double stepDuration = node.getDouble("simulation.step.duration", 0.1);
        return new SimulationPreferences(node, stepDuration);
    }

    public static void setPrefs(SimulationPreferences prefs) {
        SimulationPreferenceUtil.setPrefs(InstanceScope.INSTANCE, prefs);
    }

    public static void flushPrefs(SimulationPreferences prefs) throws BackingStoreException {
        IEclipsePreferences p = SimulationPreferenceUtil._setPrefs(InstanceScope.INSTANCE, prefs);
        p.flush();
    }

    public static void setPrefs(IScopeContext context, SimulationPreferences prefs) {
        SimulationPreferenceUtil._setPrefs(context, prefs);
    }

    private static IEclipsePreferences _setPrefs(IScopeContext context, SimulationPreferences prefs) {
        IEclipsePreferences node = context.getNode("org.simantics.simulation.ui");
        node.putDouble("simulation.step.duration", prefs.stepDuration);
        return node;
    }
}

