/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.cluster;

import gnu.trove.map.hash.TIntShortHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import org.simantics.acorn.cluster.ClusterBig;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterSupport2;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ExternalValueException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterMapSmall;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.procore.cluster.CompleteTable;
import org.simantics.db.procore.cluster.CompleteTableSmall;
import org.simantics.db.procore.cluster.ForeignTableSmall;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.OutOfSpaceException;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceTableSmall;
import org.simantics.db.procore.cluster.ValueTableSmall;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

public final class ClusterSmall
extends ClusterImpl {
    private static final int TABLE_HEADER_SIZE = 8;
    private static final int RESOURCE_TABLE_OFFSET = 0;
    private static final int PREDICATE_TABLE_OFFSET = 8;
    private static final int OBJECT_TABLE_OFFSET = 16;
    private static final int VALUE_TABLE_OFFSET = 24;
    private static final int FLAT_TABLE_OFFSET = 32;
    private static final int COMPLETE_TABLE_OFFSET = 40;
    private static final int FOREIGN_TABLE_OFFSET = 48;
    private static final int INT_HEADER_SIZE = 56;
    private final int clusterBits;
    private final ResourceTableSmall resourceTable;
    private final PredicateTable predicateTable;
    private final ObjectTable objectTable;
    private final ValueTableSmall valueTable;
    private final ForeignTableSmall foreignTable;
    private final CompleteTableSmall completeTable;
    private final ClusterMapSmall clusterMap;
    private final int[] headerTable;
    public final ClusterSupport2 clusterSupport;
    private boolean proxy;
    private boolean deleted = false;
    static long fTime = 0L;

    protected ClusterSmall() {
        this.proxy = true;
        this.headerTable = null;
        this.resourceTable = null;
        this.foreignTable = null;
        this.predicateTable = null;
        this.objectTable = null;
        this.valueTable = null;
        this.completeTable = null;
        this.clusterMap = null;
        this.clusterSupport = null;
        this.clusterBits = 0;
        this.importance = 0L;
    }

    public ClusterSmall(IClusterTable clusterTable, ClusterUID clusterUID, int clusterKey, ClusterSupport2 support) {
        super(clusterTable, clusterUID, clusterKey, support);
        this.proxy = true;
        this.headerTable = null;
        this.resourceTable = null;
        this.foreignTable = null;
        this.predicateTable = null;
        this.objectTable = null;
        this.valueTable = null;
        this.completeTable = null;
        this.clusterMap = null;
        this.clusterSupport = support;
        this.clusterBits = 0;
        this.importance = 0L;
    }

    ClusterSmall(ClusterUID clusterUID, int clusterKey, ClusterSupport2 support, IClusterTable clusterTable) {
        super(clusterTable, clusterUID, clusterKey, support);
        this.proxy = false;
        this.clusterSupport = support;
        this.headerTable = new int[56];
        this.resourceTable = new ResourceTableSmall((TableSizeListener)this, this.headerTable, 0);
        this.foreignTable = new ForeignTableSmall((ClusterBase)this, this.headerTable, 48);
        this.predicateTable = new PredicateTable((TableSizeListener)this, this.headerTable, 8);
        this.objectTable = new ObjectTable((TableSizeListener)this, this.headerTable, 16);
        this.valueTable = new ValueTableSmall((TableSizeListener)this, this.headerTable, 24);
        this.completeTable = new CompleteTableSmall((TableSizeListener)this, this.headerTable, 40);
        this.clusterMap = new ClusterMapSmall((TableSizeListener)this, this.foreignTable);
        this.clusterBits = ClusterTraitsBase.getClusterBits((int)clusterKey);
        this.importance = 0L;
    }

    protected ClusterSmall(IClusterTable clusterTable, long[] longs, int[] ints, byte[] bytes, ClusterSupport2 support, int clusterKey) throws DatabaseException {
        super(clusterTable, ClusterSmall.checkValidity(-1L, longs, ints, bytes), clusterKey, support);
        this.proxy = false;
        this.clusterSupport = support;
        if (ints.length < 56) {
            throw new IllegalArgumentException("Too small integer table for cluster.");
        }
        this.headerTable = ints;
        this.resourceTable = new ResourceTableSmall((TableSizeListener)this, ints, 0, longs);
        this.foreignTable = new ForeignTableSmall((ClusterBase)this, this.headerTable, 48, longs);
        this.predicateTable = new PredicateTable((TableSizeListener)this, ints, 8, ints);
        this.objectTable = new ObjectTable((TableSizeListener)this, ints, 16, ints);
        this.valueTable = new ValueTableSmall((TableSizeListener)this, ints, 24, bytes);
        this.completeTable = new CompleteTableSmall((TableSizeListener)this, this.headerTable, 40, ints);
        this.clusterMap = new ClusterMapSmall((TableSizeListener)this, this.foreignTable);
        this.clusterBits = ClusterTraitsBase.getClusterBits((int)clusterKey);
    }

    void analyse() {
        System.out.println("Cluster " + this.clusterId);
        System.out.println("-size:" + this.getUsedSpace());
        System.out.println(" -rt:" + (this.resourceTable.getTableCapacity() * 8 + 8));
        System.out.println(" -ft:" + this.foreignTable.getTableCapacity() * 8);
        System.out.println(" -pt:" + this.predicateTable.getTableCapacity() * 4);
        System.out.println(" -ot:" + this.objectTable.getTableCapacity() * 4);
        System.out.println(" -ct:" + this.completeTable.getTableCapacity() * 4);
        System.out.println(" -vt:" + this.valueTable.getTableCapacity());
        System.out.println("-resourceTable:");
        System.out.println(" -resourceCount=" + this.resourceTable.getResourceCount());
        System.out.println(" -size=" + this.resourceTable.getTableSize());
        System.out.println(" -capacity=" + this.resourceTable.getTableCapacity());
        System.out.println(" -count=" + this.resourceTable.getTableCount());
        System.out.println(" -size=" + this.resourceTable.getTableSize());
    }

    public void checkDirectReference(int dr) throws DatabaseException {
        if (!ClusterTraits.statementIndexIsDirect((int)dr)) {
            throw new ValidationException("Reference is not direct. Reference=" + dr);
        }
        if (ClusterTraits.isFlat((int)dr)) {
            throw new ValidationException("Reference is flat. Reference=" + dr);
        }
        if (ClusterTraits.isLocal((int)dr)) {
            if (dr < 1 || dr > this.resourceTable.getUsedSize()) {
                throw new ValidationException("Illegal local reference. Reference=" + dr);
            }
        } else {
            int fi = ClusterTraits.getForeignIndexFromReference((int)dr);
            int ri = ClusterTraits.getResourceIndexFromForeignReference((int)dr);
            if (fi < 1 || fi > this.foreignTable.getUsedSize()) {
                throw new ValidationException("Illegal foreign reference. Reference=" + dr + " foreign index=" + fi);
            }
            if (ri < 1 || ri > ClusterTraits.getMaxNumberOfResources()) {
                throw new ValidationException("Illegal foreign reference. Reference=" + dr + " resource index=" + ri);
            }
        }
    }

    public void checkPredicateIndex(int pi) throws DatabaseException {
    }

    public void checkObjectSetReference(int or) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect((int)or)) {
            throw new ValidationException("Illegal object set reference. Reference=" + or);
        }
        int oi = ClusterTraits.statementIndexGet((int)or);
        this.objectTable.checkObjectSetIndex((ClusterBase)this, oi);
    }

    public void checkValueInit() throws DatabaseException {
        this.valueTable.checkValueInit();
    }

    public void checkValue(int capacity, int index) throws DatabaseException {
        this.valueTable.checkValue(capacity, index);
    }

    public void checkValueFini() throws DatabaseException {
        this.valueTable.checkValueFini();
    }

    public void checkForeingIndex(int fi) throws DatabaseException {
        if (fi < 1 || fi > this.foreignTable.getUsedSize()) {
            throw new ValidationException("Illegal foreign index=" + fi);
        }
    }

    public void checkCompleteSetReference(int cr) throws DatabaseException {
        if (!ClusterTraits.completeReferenceIsMultiple((int)cr)) {
            throw new ValidationException("Illegal complete set reference. Reference=" + cr);
        }
        int ci = cr;
        this.completeTable.checkCompleteSetIndex((ClusterBase)this, ci);
    }

    public void check() throws DatabaseException {
    }

    public ClusterI.CompleteTypeEnum getCompleteType(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceRef = this.getLocalReference(resourceKey);
        ClusterI.CompleteTypeEnum ct = this.resourceTable.getCompleteType((int)resourceRef);
        return ct;
    }

    public int getCompleteObjectKey(int resourceKey, ClusterSupport support) throws DatabaseException {
        int resourceIndex;
        int clusterIndex;
        short resourceIndexOld = this.getLocalReference(resourceKey);
        int completeRef = this.resourceTable.getCompleteObjectRef((int)resourceIndexOld);
        if (completeRef == 0) {
            throw new DatabaseException("Resource's complete object refernce is null. Resource key=" + resourceKey + ".");
        }
        ClusterI.CompleteTypeEnum completeType = this.resourceTable.getCompleteType((int)resourceIndexOld);
        if (completeType == ClusterI.CompleteTypeEnum.NotComplete) {
            throw new DatabaseException("Resource has multiple complete objects. Resource key=" + resourceKey + ".");
        }
        if (ClusterTraitsSmall.resourceRefIsLocal((short)completeRef)) {
            clusterIndex = this.clusterKey;
            resourceIndex = completeRef;
        } else {
            ResourceUID resourceUID = this.clusterMap.getForeignResourceUID((short)completeRef);
            ClusterUID uid = resourceUID.asCID();
            clusterIndex = this.clusterSupport.getClusterKeyByUID(0L, uid.second);
            resourceIndex = resourceUID.getIndex();
        }
        int key = ClusterTraits.createResourceKey((int)clusterIndex, (int)resourceIndex);
        return key;
    }

    public boolean isComplete(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceRef = this.getLocalReference(resourceKey);
        ClusterI.CompleteTypeEnum completeType = this.resourceTable.getCompleteType((int)resourceRef);
        boolean complete = completeType != ClusterI.CompleteTypeEnum.NotComplete;
        return complete;
    }

    public int getSingleObject(int resourceKey, int predicateKey, int objectIndex, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        return this.objectTable.getSingleObject(objectIndex, support, (Modifier)this);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, int objectIndex, AsyncMultiProcedure<Resource> procedure, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, support, (int)pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
            return;
        }
        this.objectTable.foreachObject(graph, objectIndex, procedure, (Modifier)this);
    }

    public <C> void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, int objectIndex, C context, AsyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            this.resourceTable.foreachObject((int)resourceIndex, graph, context, procedure, support, (int)pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
            return;
        }
        this.objectTable.foreachObject(graph, objectIndex, context, procedure, (Modifier)this);
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, int objectIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, (Modifier)this, pRef, pCompleteType, (CompleteTable)this.completeTable);
        }
        return this.objectTable.foreachObject(objectIndex, procedure, context, support, (Modifier)this);
    }

    public int getSingleObject(int resourceKey, int predicateKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
        int completeType = ClusterTraitsBase.getCompleteTypeIntFromResourceKey((int)predicateKey);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterI.CompleteTypeEnum.make((int)completeType);
        if (completeType > 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public <T> int getSingleObject(int resourceKey, ForPossibleRelatedValueProcedure<T> procedure, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        int predicateKey = procedure.predicateKey;
        int clusterKey = ClusterTraitsBase.getClusterMaskFromResourceKey((int)resourceKey);
        short pRef = 0;
        if (procedure.clusterKey[0] == clusterKey) {
            pRef = (short)procedure.predicateReference[0];
        } else {
            pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            procedure.clusterKey[0] = clusterKey;
            procedure.predicateReference[0] = pRef;
        }
        ClusterI.CompleteTypeEnum pCompleteType = procedure.completeType;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public <C, T> int getSingleObject(int resourceKey, ForPossibleRelatedValueContextProcedure<C, T> procedure, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        int predicateKey = procedure.predicateKey;
        int clusterKey = ClusterTraitsBase.getClusterMaskFromResourceKey((int)resourceKey);
        short pRef = 0;
        if (procedure.clusterKey[0] == clusterKey) {
            pRef = (short)procedure.predicateReference[0];
        } else {
            pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            procedure.clusterKey[0] = clusterKey;
            procedure.predicateReference[0] = pRef;
        }
        ClusterI.CompleteTypeEnum pCompleteType = procedure.completeType;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, (CompleteTable)this.completeTable, (Modifier)this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, AsyncMultiProcedure<Resource> procedure) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, ForEachObjectProcedure procedure) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <C> void forObjects(ReadGraphImpl graph, int resourceKey, C context, ForEachObjectContextProcedure<C> procedure) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, (Modifier)this, pRef, pCompleteType, (CompleteTable)this.completeTable);
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, (Modifier)this, pRef, pCompleteType, (CompleteTable)this.completeTable);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.forObjects(resourceKey, predicateKey, objectIndex, procedure, context, support);
    }

    public <Context> boolean forPredicates(int resourceKey, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.foreachPredicate((int)resourceIndex, procedure, context, support, (Modifier)this, (CompleteTable)this.completeTable);
        }
        boolean broken = this.resourceTable.foreachPredicate((int)resourceIndex, procedure, context, support, (Modifier)this, (CompleteTable)this.completeTable);
        if (broken) {
            return true;
        }
        return this.predicateTable.foreachPredicate(predicateIndex, procedure, context, support, (Modifier)this);
    }

    @Override
    public ClusterI addRelation(int sResourceKey, ClusterUID puid, int pResourceKey, ClusterUID ouid, int oResourceKey, ClusterSupport support) throws DatabaseException {
        boolean ret;
        if (this.proxy) {
            throw new UnsupportedOperationException();
        }
        try {
            short sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)2);
            short pri = this.getReferenceOrCreateIfForeign(pResourceKey, puid, support, (byte)0);
            short ori = this.getReferenceOrCreateIfForeign(oResourceKey, ouid, support, (byte)0);
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
            ret = this.addRelationInternal(sri, pri, ori, completeType);
            this.calculateModifiedId();
        }
        catch (OutOfSpaceException outOfSpaceException) {
            ClusterI cluster2;
            boolean streamOff = support.getStreamOff();
            if (!streamOff) {
                support.cancelStatement((Object)this);
                support.setStreamOff(true);
            }
            ClusterBig cluster = this.toBig(this.clusterSupport);
            if (!streamOff) {
                support.setStreamOff(false);
            }
            if (cluster != (cluster2 = cluster.addRelation(sResourceKey, pResourceKey, oResourceKey, support))) {
                throw new DatabaseException("Internal error. Contact application support.");
            }
            return cluster;
        }
        if (ret) {
            support.addStatement((Object)this);
            return this;
        }
        support.cancelStatement((Object)this);
        return null;
    }

    public ClusterI addRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        boolean ret;
        if (this.proxy) {
            throw new UnsupportedOperationException();
        }
        try {
            short sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)2);
            short pri = this.getReferenceOrCreateIfForeign(pResourceKey, support, (byte)0);
            short ori = this.getReferenceOrCreateIfForeign(oResourceKey, support, (byte)0);
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
            ret = this.addRelationInternal(sri, pri, ori, completeType);
            this.calculateModifiedId();
        }
        catch (OutOfSpaceException outOfSpaceException) {
            ClusterI cluster2;
            boolean streamOff = support.getStreamOff();
            if (!streamOff) {
                support.cancelStatement((Object)this);
                support.setStreamOff(true);
            }
            ClusterBig cluster = this.toBig(this.clusterSupport);
            if (!streamOff) {
                support.setStreamOff(false);
            }
            if (cluster != (cluster2 = cluster.addRelation(sResourceKey, pResourceKey, oResourceKey, support))) {
                throw new DatabaseException("Internal error. Contact application support.");
            }
            return cluster;
        }
        if (ret) {
            support.addStatement((Object)this);
            return this;
        }
        support.cancelStatement((Object)this);
        return null;
    }

    public boolean removeRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        short sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)3);
        short pri = this.getInternalReferenceOrZeroAnd(pResourceKey, support, (byte)0);
        short ori = this.getInternalReferenceOrZeroAnd(oResourceKey, support, (byte)0);
        boolean ret = false;
        if (pri != 0 && ori != 0) {
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
            ret = this.removeRelationInternal(sri, pri, ori, completeType, support);
            this.calculateModifiedId();
        }
        if (ret) {
            support.removeStatement((Object)this);
        } else {
            support.cancelStatement((Object)this);
        }
        return ret;
    }

    public void denyRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        short s = this.checkResourceKeyIsOursAndGetResourceIndexIf(sResourceKey, support);
        ResourceReferenceAndCluster p = this.checkResourceKeyAndGetResourceIndexIf(pResourceKey, support);
        ResourceReferenceAndCluster o = this.checkResourceKeyAndGetResourceIndexIf(oResourceKey, support);
        if (s == 0 || p.reference == 0 || o.reference == 0) {
            return;
        }
        ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
        boolean ret = this.removeRelationInternal(s, p.reference, o.reference, completeType, support);
        if (ret) {
            support.addStatementIndex((Object)this, sResourceKey, this.getClusterUID(), (byte)3);
            support.addStatementIndex((Object)this, pResourceKey, p.clusterUID, (byte)0);
            support.addStatementIndex((Object)this, oResourceKey, o.clusterUID, (byte)0);
            support.removeStatement((Object)this);
        }
        this.calculateModifiedId();
    }

    public InputStream getValueStream(int resourceKey, ClusterSupport support) throws DatabaseException {
        byte[] buffer;
        block3: {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
            try {
                buffer = this.resourceTable.getValue(this.valueTable, (int)resourceIndex);
                if (buffer != null) break block3;
                return null;
            }
            catch (ExternalValueException externalValueException) {
                return support.getValueStreamEx((int)resourceIndex, this.clusterUID.second);
            }
        }
        return new ByteArrayInputStream(buffer);
    }

    public byte[] getValue(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
        try {
            return this.resourceTable.getValue(this.valueTable, (int)resourceIndex);
        }
        catch (ExternalValueException externalValueException) {
            return this.clusterSupport.impl.getResourceFile(this.clusterUID.asBytes(), resourceIndex);
        }
    }

    public boolean hasValue(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        return this.resourceTable.hasValue((int)resourceIndex);
    }

    public boolean removeValue(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReferenceAnd(resourceKey, support, (byte)5);
        support.removeValue((Object)this);
        this.calculateModifiedId();
        return this.resourceTable.removeValue(this.valueTable, (int)resourceIndex);
    }

    public ClusterI setValue(int rResourceId, byte[] value, int length, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)4);
        support.setValue((Object)this, this.getClusterId(), value, length);
        try {
            this.resourceTable.setValue(this.valueTable, (int)resourceIndex, value, length);
            this.calculateModifiedId();
            return this;
        }
        catch (OutOfSpaceException outOfSpaceException) {
            boolean streamOff = support.getStreamOff();
            if (!streamOff) {
                support.setStreamOff(true);
            }
            ClusterBig cluster = this.toBig(support);
            cluster.setValue(rResourceId, value, length, support);
            if (!streamOff) {
                support.setStreamOff(false);
            }
            return cluster;
        }
    }

    public ClusterI modiValueEx(int rResourceId, long voffset, int length, byte[] value, int offset, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)6);
        support.modiValue((Object)this, this.getClusterId(), voffset, length, value, offset);
        this.resourceTable.setValueEx(this.valueTable, (int)resourceIndex);
        this.calculateModifiedId();
        return this;
    }

    public byte[] readValueEx(int rResourceId, long voffset, int length, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(rResourceId);
        boolean isExternal = this.resourceTable.isValueEx(this.valueTable, (int)resourceIndex);
        if (!isExternal) {
            throw new DatabaseException("ClusterI.readValue supported only for external value. Resource key=" + rResourceId);
        }
        return support.getValueEx((int)resourceIndex, this.getClusterId(), voffset, length);
    }

    @Override
    public boolean isValueEx(int resourceKey) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        return this.resourceTable.isValueEx(this.valueTable, (int)resourceIndex);
    }

    public long getValueSizeEx(int rResourceId, ClusterSupport support) throws DatabaseException, ExternalValueException {
        short resourceIndex = this.getLocalReference(rResourceId);
        boolean isExternal = this.resourceTable.isValueEx(this.valueTable, (int)resourceIndex);
        if (!isExternal) {
            throw new ExternalValueException("ClusterI.getValueSizeEx supported only for external value. Resource key=" + rResourceId);
        }
        return support.getValueSizeEx((int)resourceIndex, this.getClusterId());
    }

    public void setValueEx(int rResourceId) throws DatabaseException {
        short resourceIndex = this.getLocalReference(rResourceId);
        this.resourceTable.setValueEx(this.valueTable, (int)resourceIndex);
    }

    public int createResource(ClusterSupport support) throws DatabaseException {
        if (this.proxy) {
            throw new UnsupportedOperationException();
        }
        short resourceIndex = this.resourceTable.createResource();
        this.calculateModifiedId();
        support.createResource((Object)this, resourceIndex, this.getClusterId());
        return ClusterTraits.createResourceKey((int)this.clusterKey, (int)resourceIndex);
    }

    public boolean hasResource(int resourceKey, ClusterSupport support) {
        short resourceIndex;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            return false;
        }
        try {
            resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        }
        catch (DatabaseException databaseException) {
            return false;
        }
        return resourceIndex > 0 & resourceIndex <= this.resourceTable.getTableCount();
    }

    public int getNumberOfResources(ClusterSupport support) throws DatabaseException {
        if (this.proxy) {
            throw new UnsupportedOperationException();
        }
        return this.resourceTable.getUsedSize();
    }

    public int getNumberOfResources() throws IllegalAcornStateException {
        if (this.proxy) {
            throw new IllegalAcornStateException("proxy == true for " + this.clusterId);
        }
        return this.resourceTable.getUsedSize();
    }

    public long getUsedSpace() {
        if (this.isEmpty()) {
            return 0L;
        }
        long rt = this.resourceTable.getTableCapacity() * 8 + 8;
        long ft = this.foreignTable.getTableCapacity() * 8;
        long pt = this.predicateTable.getTableCapacity() * 4;
        long ot = this.objectTable.getTableCapacity() * 4;
        long ct = this.completeTable.getTableCapacity() * 4;
        long vt = this.valueTable.getTableCapacity() * 1;
        long cm = this.clusterMap.getUsedSpace();
        return rt + ft + pt + ot + ct + vt + cm;
    }

    public boolean isEmpty() {
        if (this.resourceTable == null) {
            return true;
        }
        return this.resourceTable.getTableCount() == 0;
    }

    public void printDebugInfo(String message, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented!");
    }

    private short getInternalReferenceOrZero2(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
        if (!ClusterTraitsBase.isCluster((int)this.clusterBits, (int)resourceKey)) {
            return this.clusterMap.getForeignReferenceOrZero(resourceKey);
        }
        return resourceIndex;
    }

    private short getInternalReferenceOrZeroAnd(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterUID clusterUID = this.clusterSupport.getClusterUIDByResourceKey(resourceKey);
            short foreignRef = this.clusterMap.getForeignReferenceOrZero(resourceKey);
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            return foreignRef;
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private final short getLocalReference(int resourceKey) throws DatabaseException {
        return ClusterTraits.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
    }

    private final short getLocalReferenceAnd(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private short checkResourceKeyIsOursAndGetResourceIndexIf(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterShortId = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterShortId) {
            return 0;
        }
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        return resourceIndex;
    }

    private short getReferenceOrCreateIfForeign(int resourceKey, ClusterUID clusterUID, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            short ref = this.clusterMap.getForeignReferenceOrCreateByResourceKey(resourceKey, clusterUID);
            return ref;
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private short getReferenceOrCreateIfForeign(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterUID clusterUID = this.clusterSupport.getClusterUIDByResourceKey(resourceKey);
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            short ref = this.clusterMap.getForeignReferenceOrCreateByResourceKey(resourceKey, clusterUID);
            return ref;
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private ResourceReferenceAndCluster checkResourceKeyAndGetResourceIndexIf(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterBase foreignCluster = support.getClusterByClusterKey(clusterKey);
            ClusterUID clusterUID = foreignCluster.getClusterUID();
            short ref = this.clusterMap.getForeignReferenceOrZero(resourceKey);
            return new ResourceReferenceAndCluster(ref, clusterUID);
        }
        return new ResourceReferenceAndCluster(resourceIndex, this.getClusterUID());
    }

    public final int execute(int resourceReference) throws DatabaseException {
        int key;
        short resourceRef = (short)resourceReference;
        if (ClusterTraitsSmall.resourceRefIsLocal((short)resourceRef)) {
            key = this.clusterBits | resourceRef;
        } else {
            short foreignIndex = ClusterTraitsSmall.resourceRefGetForeignIndex((short)resourceRef);
            ResourceUID resourceUID = this.foreignTable.getResourceUID((int)foreignIndex);
            int clusterKey = this.clusterSupport.getClusterKeyByClusterUIDOrMake(resourceUID.asCID());
            key = ClusterTraitsBase.createResourceKey((int)clusterKey, (int)resourceUID.getIndex());
        }
        return key;
    }

    private boolean addRelationInternal(short sReference, short pReference, short oReference, ClusterI.CompleteTypeEnum completeType) throws DatabaseException {
        int predicateIndex = this.resourceTable.addStatement((int)sReference, pReference, oReference, this.predicateTable, this.objectTable, completeType, (CompleteTable)this.completeTable);
        if (predicateIndex == 0) {
            return true;
        }
        if (predicateIndex < 0) {
            return false;
        }
        int newPredicateIndex = this.predicateTable.addPredicate(predicateIndex, 0xFFFF & pReference, 0xFFFF & oReference, this.objectTable);
        if (newPredicateIndex == 0) {
            return false;
        }
        if (predicateIndex != newPredicateIndex) {
            this.resourceTable.setPredicateIndex((int)sReference, newPredicateIndex);
        }
        return true;
    }

    private boolean removeRelationInternal(int sResourceIndex, short pResourceIndex, short oResourceIndex, ClusterI.CompleteTypeEnum completeType, ClusterSupport support) throws DatabaseException {
        int predicateIndex = this.resourceTable.getPredicateIndex(sResourceIndex);
        if (predicateIndex == 0 || ClusterI.CompleteTypeEnum.NotComplete != completeType) {
            return this.resourceTable.removeStatementFromCache(sResourceIndex, pResourceIndex, oResourceIndex, completeType, (CompleteTable)this.completeTable);
        }
        PredicateTable.Status ret = this.predicateTable.removePredicate(predicateIndex, 0xFFFF & pResourceIndex, 0xFFFF & oResourceIndex, this.objectTable);
        switch (ret) {
            case NothingRemoved: {
                return false;
            }
            case PredicateRemoved: {
                if (this.predicateTable.getPredicateSetSize(predicateIndex) != 0) break;
                this.resourceTable.setPredicateIndex(sResourceIndex, 0);
            }
        }
        this.resourceTable.removeStatement(sResourceIndex, pResourceIndex, oResourceIndex, completeType, (CompleteTable)this.completeTable, this.predicateTable, this.objectTable, support);
        return true;
    }

    public void load() {
        throw new Error("Not supported.");
    }

    public void load(Consumer<DatabaseException> r) {
        throw new Error("Not supported.");
    }

    public boolean contains(int resourceKey) {
        return ClusterTraitsBase.isCluster((int)this.clusterBits, (int)resourceKey);
    }

    public void load(ClusterSupport support, Runnable callback) {
        throw new UnsupportedOperationException();
    }

    public ClusterI getClusterByResourceKey(int resourceKey, ClusterSupport support) {
        throw new Error();
    }

    public void increaseReferenceCount(int amount) {
        throw new Error();
    }

    public void decreaseReferenceCount(int amount) {
        throw new Error();
    }

    public int getReferenceCount() {
        throw new Error();
    }

    public void releaseMemory() {
    }

    public void compact() {
        this.clusterMap.compact();
    }

    @Override
    public boolean isLoaded() {
        return !this.proxy;
    }

    public ClusterBig toBig(ClusterSupport support) throws DatabaseException {
        ClusterBig big = new ClusterBig((IClusterTable)this.clusterSupport, this.getClusterUID(), this.clusterKey, (ClusterSupport2)support);
        big.cc = this.cc;
        this.resourceTable.toBig((ClusterBase)big, support, (ClusterBase)this);
        big.foreignLookup = this.foreignLookup;
        big.change = this.change;
        this.cc = null;
        this.foreignLookup = null;
        this.change = null;
        return big;
    }

    public ClusterI.ClusterTypeEnum getType() {
        return ClusterI.ClusterTypeEnum.SMALL;
    }

    public boolean getImmutable() {
        int status = this.resourceTable.getClusterStatus();
        return (status & 1) == 1;
    }

    public void setImmutable(boolean immutable, ClusterSupport support) {
        if (this.resourceTable != null) {
            int status = this.resourceTable.getClusterStatus();
            status = immutable ? (status |= 1) : (status &= 0xFFFFFFFE);
            this.resourceTable.setClusterStatus(status);
        }
        support.setImmutable((Object)this, immutable);
    }

    public String toString() {
        try {
            final TIntHashSet set = new TIntHashSet();
            TIntShortHashMap map = this.foreignTable.getResourceHashMap();
            map.forEachKey(new TIntProcedure(){

                public boolean execute(int value) {
                    set.add(value & 0xFFFFF000);
                    return true;
                }
            });
            return "ClusterSmall[" + this.getClusterUID() + " - " + this.getClusterId() + " - " + this.getNumberOfResources() + " - " + this.foreignTable.getResourceHashMap().size() + " - " + set.size() + "]";
        }
        catch (DatabaseException databaseException) {
            try {
                return "ClusterSmall[" + this.getNumberOfResources() + "]";
            }
            catch (IllegalAcornStateException e1) {
                Logger.defaultLogError((Throwable)((Object)e1));
                e1.printStackTrace();
                return "An exception occured!!";
            }
        }
    }

    @Override
    public byte[] storeBytes() throws IOException {
        int rawPos;
        int byteSize = this.valueTable.getTableSize();
        int longSize = 7 + this.resourceTable.getTableSize() + this.foreignTable.getTableSize();
        int intSize = 56 + this.predicateTable.getTableSize() + this.objectTable.getTableSize() + this.completeTable.getTableSize();
        byte[] raw = new byte[12 + byteSize + 8 * longSize + 4 * intSize];
        int[] currentHeader = Arrays.copyOf(this.headerTable, 56);
        Bytes.writeLE((byte[])raw, (int)0, (int)byteSize);
        Bytes.writeLE((byte[])raw, (int)4, (int)intSize);
        Bytes.writeLE((byte[])raw, (int)8, (int)longSize);
        int intBase = rawPos = this.valueTable.storeBytes(raw, 0, 12);
        rawPos += 224;
        rawPos = this.predicateTable.storeBytes(raw, rawPos - intBase >> 2, rawPos);
        rawPos = this.objectTable.storeBytes(raw, rawPos - intBase >> 2, rawPos);
        int longBase = rawPos = this.completeTable.storeBytes(raw, rawPos - intBase >> 2, rawPos);
        rawPos += 56;
        rawPos = this.resourceTable.storeBytes(raw, rawPos - longBase >> 3, rawPos);
        rawPos = this.foreignTable.storeBytes(raw, rawPos - longBase >> 3, rawPos);
        Bytes.writeLE8((byte[])raw, (int)longBase, (long)-1L);
        Bytes.writeLE8((byte[])raw, (int)(longBase + 8), (long)1L);
        Bytes.writeLE8((byte[])raw, (int)(longBase + 16), (long)0L);
        Bytes.writeLE8((byte[])raw, (int)(longBase + 24), (long)this.clusterUID.second);
        int i = 0;
        while (i < 56) {
            int v = this.headerTable[i];
            Bytes.writeLE((byte[])raw, (int)intBase, (int)v);
            intBase += 4;
            ++i;
        }
        i = 0;
        while (i < 56) {
            this.headerTable[i] = currentHeader[i];
            ++i;
        }
        return raw;
    }

    @Override
    public ClusterImpl.ClusterTables store() throws IOException {
        ClusterImpl.ClusterTables result = new ClusterImpl.ClusterTables();
        int[] currentHeader = Arrays.copyOf(this.headerTable, 56);
        int byteSize = this.valueTable.getTableSize();
        byte[] byteBytes = new byte[byteSize];
        this.valueTable.store((Object)byteBytes, 0);
        result.bytes = byteBytes;
        int longSize = 7 + this.resourceTable.getTableSize() + this.foreignTable.getTableSize();
        long[] longBytes = new long[longSize];
        longBytes[0] = -1L;
        longBytes[1] = 1L;
        longBytes[2] = 0L;
        longBytes[3] = this.clusterUID.second;
        int longPos = this.resourceTable.store((Object)longBytes, 7);
        this.foreignTable.store((Object)longBytes, longPos);
        result.longs = longBytes;
        int intSize = 56 + this.predicateTable.getTableSize() + this.objectTable.getTableSize() + this.completeTable.getTableSize();
        int[] intBytes = new int[intSize];
        int intPos = 56;
        intPos = this.predicateTable.store((Object)intBytes, intPos);
        intPos = this.objectTable.store((Object)intBytes, intPos);
        intPos = this.completeTable.store((Object)intBytes, intPos);
        int i = 0;
        while (i < 56) {
            int v;
            intBytes[i] = v = this.headerTable[i];
            ++i;
        }
        result.ints = intBytes;
        i = 0;
        while (i < 56) {
            this.headerTable[i] = currentHeader[i];
            ++i;
        }
        return result;
    }

    @Override
    protected int getResourceTableCount() {
        return this.resourceTable.getTableCount();
    }

    public boolean getDeleted() {
        if (this.deleted) {
            return true;
        }
        int status = this.resourceTable.getClusterStatus();
        return (status & 2) == 2;
    }

    public void setDeleted(boolean set, ClusterSupport support) {
        this.deleted = set;
        if (this.resourceTable != null) {
            int status = this.resourceTable.getClusterStatus();
            status = set ? (status |= 2) : (status &= 0xFFFFFFFD);
            this.resourceTable.setClusterStatus(status);
        }
        if (support != null) {
            support.setDeleted((Object)this, set);
        }
    }

    public Table<?> getPredicateTable() {
        return this.predicateTable;
    }

    public Table<?> getForeignTable() {
        return this.foreignTable;
    }

    public int makeResourceKey(int pRef) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public Table<?> getCompleteTable() {
        return this.completeTable;
    }

    public Table<?> getValueTable() {
        return this.valueTable;
    }

    public Table<?> getObjectTable() {
        return this.objectTable;
    }

    private class ResourceReferenceAndCluster {
        public final short reference;
        public final ClusterUID clusterUID;

        ResourceReferenceAndCluster(short reference, ClusterUID clusterUID) {
            this.reference = reference;
            this.clusterUID = clusterUID;
        }
    }
}

