package org.simantics.trend.impl;

import java.awt.Color;

import org.simantics.trend.configuration.ViewProfile;

/**
 * Internal caching class for chart rendering related data that only needs to be
 * recreated when the rendered TrendSpec changes, not on every rendered frame.
 * 
 * @author Tuukka Lehtonen
 */
class ViewRenderingProfile {

    public Color backgroundColor1 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_BOTTOM;
    public Color backgroundColor2 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_TOP;;
    public Color gridColor = Plot.GRID_LINE_COLOR;

    public ViewRenderingProfile read(ViewProfile p) {
        if (p.backgroundColor != null) {
            float[] bg = p.backgroundColor;
            int len = bg.length;
            if (len >= 6) {
                backgroundColor1 = toColor(bg, 0);
                backgroundColor2 = toColor(bg, 3);
            } else if (len >= 3) {
                backgroundColor1 = toColor(bg, 0);
                backgroundColor2 = null;
            }
        } else {
            backgroundColor1 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_BOTTOM;
            backgroundColor2 = Plot.PLOT_AREA_BG_GRADIENT_COLOR_TOP;
        }

        if (p.gridColor != null && p.gridColor.length >= 3) {
            gridColor = toColor(p.gridColor, 0);
        } else {
            gridColor = Plot.GRID_LINE_COLOR;
        }

        return this;
    }

    private static Color toColor(float[] array, int offset) {
        return new Color(clamp(array[offset]), clamp(array[offset+1]), clamp(array[offset+2]));
    }

    private static float clamp(float v) {
        return Math.max(0, Math.min(v, 1));
    }

}
