/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

/**
 * A request for calculating the set of issue context resources for the
 * specified issue resource.
 * 
 * @author Antti Villberg
 */
public class IssueResourceContexts extends ResourceRead<Set<Resource>> {

    public IssueResourceContexts(Resource issue) {
        super(issue);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance(graph);
        Set<Resource> result = new THashSet<Resource>();
        result.addAll(graph.getObjects(resource, ISSUE.Issue_HasContext));
        Resource list = graph.getPossibleObject(resource, ISSUE.Issue_HasContexts);
        if(list != null) result.addAll(ListUtils.toList(graph, list));
        return result;
    }

}
