/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Antti Villberg
 */
public class AllActiveIssues extends ResourceRead<Set<Resource>> {

    public AllActiveIssues(Resource project) {
        super(project);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        Set<Resource> result = new THashSet<Resource>();
        Instances indexedIssues = graph.getPossibleAdapter(ISSUE.Issue, Instances.class);
        for (Resource model : graph.syncRequest(new ObjectsWithType(resource, L0X.Activates, SIMU.Model))) {
            for (Resource issue : graph.syncRequest(new ObjectsWithType(model, L0.ConsistsOf, ISSUE.Issue))) {
                result.add(issue);
            }
            if (indexedIssues != null)
                result.addAll(indexedIssues.find(graph, model));
        }
        return result;
    }

}
