package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.single.SingleSetSyncListener;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableFactoryRequest;
import org.simantics.db.procedure.Listener;
import org.simantics.db.service.QueryControl;
import org.simantics.operation.Layer0X;

public class ExtendedGraphChildVariable extends StandardGraphChildVariable {

	private Map<String, Variable> extension;
	private List<Listener<Map<String, Variable>>> listeners = new ArrayList<Listener<Map<String, Variable>>>();
	
	public ExtendedGraphChildVariable(Variable parent, Resource resource) throws DatabaseException {
		super(parent, null, resource);
	}

	Map<String, Variable> getExtension(ReadGraph graph) throws DatabaseException {

		if(extension == null) {

			extension = new HashMap<String, Variable>();

			QueryControl qc = graph.getService(QueryControl.class);
			
			qc.getIndependentGraph(graph).syncRequest(new ResourceRead<Collection<VariableFactory>>(resource) {

				@Override
				public Collection<VariableFactory> perform(ReadGraph graph) throws DatabaseException {
					Layer0X L0X = Layer0X.getInstance(graph);
					ArrayList<VariableFactory> result = new ArrayList<VariableFactory>();
					for(Resource r : graph.getObjects(resource, L0X.HasChildVariables)) {
	                	VariableFactory factory = graph.adapt(r, VariableFactory.class);
	                	assert(factory != null);
						result.add(factory);
					}
					return result;
				}
		    	
		    }, new SingleSetSyncListener<VariableFactory>() {

	            @Override
	            public void add(ReadGraph graph, final VariableFactory factory) throws DatabaseException {
	            	
	            	graph.syncRequest(new VariableFactoryRequest(ExtendedGraphChildVariable.this, factory), new SingleSetSyncListener<Variable>() {

	                    @Override
	                    public void add(ReadGraph graph, final Variable child) throws DatabaseException {
	                    	String name = child.getPropertyValue(graph, Variables.NAME);
	                    	extension.put(name, child);
	                    }
	                    
	                    @Override
	                    public void remove(ReadGraph graph, Variable child) throws DatabaseException {
	                    	String name = child.getPropertyValue(graph, Variables.NAME);
	                    	Variable exist = extension.get(name);
	                    	if(exist == child) extension.remove(name);
	                    }
	                    
	                    public void finished(ReadGraph graph) throws DatabaseException {
	                    	Map<String, Variable> clone = getClone();
	                    	for(Listener<Map<String, Variable>> listener : listeners) listener.execute(clone);
	                    }

	                    @Override
	                    public boolean isDisposed() {
	                    	return false;
	                    }

	            	});
	            	
	            }
	            
	            @Override
	            public boolean isDisposed() {
	            	return false;
	            }
	            
		    });
			
		}
		
		return graph.syncRequest(new ParametrizedPrimitiveRead<Variable, Map<String, Variable>>(this) {
			
			@Override
			public void register(ReadGraph graph, Listener<Map<String, Variable>> procedure) {

				listeners.add(procedure);
				procedure.execute(getClone());
				
			}
			
		});
		
	}
	
	private Map<String, Variable> getClone() {
		Map<String, Variable> clone = new HashMap<String, Variable>();
		clone.putAll(extension);
		return clone;
	}
	
	public Variable getPossibleSpecialChild(ReadGraph graph, String name) throws DatabaseException {
		return getExtension(graph).get(name);
	}

	public void collectSpecialChildren(ReadGraph graph, Collection<Variable> children) throws DatabaseException {
		children.addAll(getExtension(graph).values());
	}
	
}
