/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.ui.wizard;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.simantics.xml.sax.ManualSchemaFileImport;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.ui.wizard.ImportProcessPage;
import org.simantics.xml.sax.ui.wizard.InputSelectionPage;
import org.simantics.xml.sax.ui.wizard.SchemaCombinationPage;

public class SchemaConversionWizard
extends Wizard
implements IImportWizard {
    InputSelectionPage inputSelectionPage;
    ImportProcessPage importProcessPage;
    SchemaCombinationPage schemaCombinationPage;

    public SchemaConversionWizard() {
        this.setWindowTitle("XML Schema conversion");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        return !this.importProcessPage.isImporting();
    }

    public void addPages() {
        this.inputSelectionPage = new InputSelectionPage();
        this.addPage((IWizardPage)this.inputSelectionPage);
        this.importProcessPage = new ImportProcessPage();
        this.addPage((IWizardPage)this.importProcessPage);
        this.schemaCombinationPage = new SchemaCombinationPage();
        this.addPage((IWizardPage)this.schemaCombinationPage);
    }

    public void doConversion() throws Exception {
        File inputFile = new File(this.inputSelectionPage.getSchemaFilename());
        File configurationFile = null;
        if (this.inputSelectionPage.getConfigurationFilename() != null) {
            configurationFile = new File(this.inputSelectionPage.getConfigurationFilename());
        }
        File outputPlugin = new File(this.inputSelectionPage.getPluginFilename());
        SchemaConverter converter = new SchemaConverter(inputFile, configurationFile, outputPlugin);
        converter.setCreateExporter(this.inputSelectionPage.createExporter);
        converter.setCreateImporter(this.inputSelectionPage.createImporter);
        converter.setCreatePGraph(this.inputSelectionPage.createPGraph);
        converter.setFileImport(new ManualSchemaFileImport(){
            String filename;

            public File getFileForLocation(final String location) throws IOException {
                if (Display.getCurrent() == null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.showDialog(location);
                        }
                    });
                } else {
                    this.showDialog(location);
                }
                if (this.filename == null) {
                    return null;
                }
                return new File(this.filename);
            }

            protected void showDialog(String location) {
                FileDialog dialog = new FileDialog(SchemaConversionWizard.this.getShell(), 4096);
                dialog.setText("Open schema file for " + location);
                this.filename = dialog.open();
            }
        });
        converter.convert();
        this.schemaCombinationPage.setOutputPlugin(outputPlugin);
    }
}

