/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.request.PossibleActiveRun;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.fmi.experiment.FMIRealm;
import org.simantics.fmi.studio.core.Activator;
import org.simantics.fmi.studio.core.FMIExperimentDB;
import org.simantics.fmi.studio.core.FMISessionManager;
import org.simantics.fmi.studio.core.IFMISessionManager;
import org.simantics.fmi.studio.core.IFMIVariableBuilder;
import org.simantics.fmi.studio.stubs.FMIStudioResource;
import org.simantics.fmil.core.FMIL;
import org.simantics.fmil.core.FMILException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIStudioSCL {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIStudioSCL.class);

    public static void activateExperiment(ReadGraph graph, Resource res) throws DatabaseException {
        ExperimentUtil.activateExperiment((RequestProcessor)graph, (Resource)res, null);
    }

    public static void activateRun(ReadGraph graph, Resource res) throws DatabaseException {
        ExperimentUtil.activateRun((RequestProcessor)graph, (Resource)res);
    }

    public static IExperiment iExperimentFMI(ReadGraph graph, Variable var) throws DatabaseException {
        Resource run = var.getParent(graph).getRepresents(graph);
        IFMIVariableBuilder builder = (IFMIVariableBuilder)graph.adapt(run, VariableBuilder.class);
        IFMISessionManager manager = builder.getSessionManager();
        FMIRealm session = manager.fmiRealmById(graph, var.getParent(graph).getURI(graph));
        return (FMIExperimentDB)session.getEngine();
    }

    public static IExperiment getPossibleActiveExperiment(ReadGraph graph, Resource resource) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
        if (model == null) {
            return null;
        }
        Variable run = (Variable)graph.syncRequest((Read)new PossibleActiveRun(model));
        if (run == null) {
            return null;
        }
        return (IExperiment)run.getPossiblePropertyValue(graph, SIMU.Run_iExperiment);
    }

    public static boolean hasActiveExperiment(ReadGraph graph, Resource resource) throws DatabaseException {
        return FMIStudioSCL.getPossibleActiveExperiment(graph, resource) != null;
    }

    public static boolean hasActiveStoppedExperiment(ReadGraph graph, Resource resource) throws DatabaseException {
        IExperiment exp = FMIStudioSCL.getPossibleActiveExperiment(graph, resource);
        if (exp == null) {
            return false;
        }
        ExperimentState state = exp.getState(graph);
        return ExperimentState.STOPPED.equals((Object)state);
    }

    public static boolean hasActiveRunningExperiment(ReadGraph graph, Resource resource) throws DatabaseException {
        IExperiment exp = FMIStudioSCL.getPossibleActiveExperiment(graph, resource);
        if (exp == null) {
            return false;
        }
        ExperimentState state = exp.getState(graph);
        return ExperimentState.RUNNING.equals((Object)state);
    }

    public static Resource createFMIRun(WriteGraph graph, final Resource experiment) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        return (Resource)graph.syncRequest((WriteResult)new WriteResultRequest<Resource>(vgs.getMemoryPersistent("experiments")){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                FMIStudioResource FMI = FMIStudioResource.getInstance((ReadGraph)graph);
                Resource run = graph.newResource();
                graph.claim(run, L0.InstanceOf, FMI.Experiment_Run);
                graph.addLiteral(run, L0.HasName, L0.NameOf, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
                graph.claim(experiment, L0.ConsistsOf, run);
                return run;
            }
        });
    }

    public static void removeFMIRun(WriteGraph graph, final Resource run) throws DatabaseException {
        String id = (String)graph.syncRequest((WriteResult)new WriteResultRequest<String>(){

            public String perform(WriteGraph graph) throws DatabaseException {
                String id = graph.getPossibleURI(run);
                graph.deny(run);
                return id;
            }
        });
        if (id != null) {
            FMISessionManager.getInstance().removeRealm(graph, id);
        } else {
            LOGGER.info("FMI run for resource " + run + " has already been removed");
        }
    }

    public static void createFMIModelAction(Resource project) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                Shell shell = display.getActiveShell();
                FileDialog dialog = new FileDialog(shell, 4096);
                dialog.setText("Choose FMU");
                dialog.setFilterExtensions(new String[]{"*.fmu"});
                dialog.setFilterNames(new String[]{"Functional Mock-up Unit (*.fmu)"});
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                try {
                    FMIStudioSCL.createFMIModel(Simantics.getProjectResource(), Paths.get(fileName, new String[0]));
                }
                catch (FMILException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static Resource createModel(WriteGraph graph, Resource type, Resource target, String name) throws DatabaseException {
        Resource model = ModelingUtils.createModel((WriteGraph)graph, (Resource)type, (Resource)target, (String)name);
        Resource conf = (Resource)graph.syncRequest((Read)new Configuration(model));
        ModelingUtils.addSCLMainToModel((WriteGraph)graph, (Resource)model, (String)"SCLMain", (String)"");
        ModelingUtils.createLocalLibrary((WriteGraph)graph, (Resource)model, (String)"Library");
        Resource book = SpreadsheetGraphUtils.createBook((WriteGraph)graph, (Resource)conf, (String)"Book1");
        SpreadsheetUtils.createSheet((WriteGraph)graph, (Resource)book, (String)"Sheet1", (String[])new String[0], (int[])new int[]{50});
        SpreadsheetUtils.createSheet((WriteGraph)graph, (Resource)book, (String)"Sheet2", (String[])new String[0], (int[])new int[]{50});
        SpreadsheetUtils.createSheet((WriteGraph)graph, (Resource)book, (String)"Sheet3", (String[])new String[0], (int[])new int[]{50});
        return model;
    }

    public static double getExperimentTime(IExperiment experiment) {
        FMIExperimentDB e = (FMIExperimentDB)experiment;
        return e.getSimulationTime();
    }

    public static boolean importFMI(Resource target, String path) throws FMILException, DatabaseException, IOException {
        Path filePath = Paths.get(path, new String[0]);
        if (target == null || path == null) {
            return false;
        }
        Resource result = FMIStudioSCL.createFMIModel(target, filePath);
        return result != null;
    }

    public static Resource importFMIR(Resource target, String path) throws FMILException, DatabaseException, IOException {
        Path filePath = Paths.get(path, new String[0]);
        if (target == null || path == null) {
            return null;
        }
        return FMIStudioSCL.createFMIModel(target, filePath);
    }

    public static Resource createFMIModel(final Resource target, Path file) throws FMILException, DatabaseException, IOException {
        Path stateLocation = Activator.stateLocation();
        String created = Long.toString(System.currentTimeMillis());
        Path store = stateLocation.resolve(created);
        Files.createDirectory(store, new FileAttribute[0]);
        Path targetLocation = store.resolve(file.getFileName());
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream stream = Files.newOutputStream(targetLocation, new OpenOption[0]);){
            Files.copy(file, stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!Files.isReadable(targetLocation)) {
            throw new IOException("File " + targetLocation.toAbsolutePath() + " is not readable so cannot load FMU!");
        }
        final String modelName = file.getFileName().toString();
        final String fmuPath = String.valueOf(created) + "/" + targetLocation.getFileName().toString();
        FMIL fmil = new FMIL();
        fmil.loadFMUFile(targetLocation.toAbsolutePath().toString());
        final String[] variables = fmil.getAllVariables();
        final String[] descriptions = fmil.getAllVariableDescriptions();
        final String[] declaredTypes = fmil.getAllVariableDeclaredTypes();
        final int[] causalities = fmil.getAllVariableCausalities();
        final int[] variabilities = fmil.getAllVariableVariabilities();
        final int[] types = fmil.getAllVariableTypes();
        String[] declaredTypeNames = fmil.getAllDeclaredTypes();
        final String[] typeDescriptions = fmil.getAllDeclaredTypeDescriptions();
        final String[] typeQuantities = fmil.getAllDeclaredTypeQuantities();
        final String[] typeUnits = fmil.getAllDeclaredTypeUnits();
        final HashMap<String, Integer> typeIndices = new HashMap<String, Integer>();
        int i = 0;
        while (i < declaredTypeNames.length) {
            typeIndices.put(declaredTypeNames[i], i);
            ++i;
        }
        fmil.unloadFMU();
        return (Resource)Simantics.sync((WriteInterface)new WriteResultRequest<Resource>(){
            Resource typeLibrary;
            Map<String, Resource> declaredTypeMap = new HashMap<String, Resource>();

            public void insert(WriteGraph graph, Resource configuration, Map<String, Resource> map, String variableName, String description, String declaredType, int type, int variability, int causality) throws DatabaseException {
                if (description.isEmpty()) {
                    description = "No description";
                }
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                FMIStudioResource FMI = FMIStudioResource.getInstance((ReadGraph)graph);
                String[] parts = variableName.split("\\.");
                NamedResource parent = new NamedResource("", configuration);
                int i = 0;
                while (i < parts.length) {
                    if (i == parts.length - 1) {
                        Resource declaredTypeResource = null;
                        if (!declaredType.isEmpty() && (declaredTypeResource = this.declaredTypeMap.get(declaredType)) == null) {
                            int index = (Integer)typeIndices.get(declaredType);
                            String typeDescription = typeDescriptions[index];
                            String typeQuantity = typeQuantities[index];
                            String typeUnit = typeUnits[index];
                            declaredTypeResource = graph.newResource();
                            graph.claim(declaredTypeResource, L0.Inherits, FMI.DeclaredType);
                            graph.addLiteral(declaredTypeResource, L0.HasName, L0.NameOf, L0.String, (Object)declaredType, (Binding)Bindings.STRING);
                            graph.addLiteral(declaredTypeResource, L0.HasDescription, L0.HasDescription_Inverse, L0.String, (Object)typeDescription, (Binding)Bindings.STRING);
                            Resource quantityValue = graph.newResource();
                            graph.claim(quantityValue, L0.InstanceOf, L0.String);
                            graph.claimValue(quantityValue, (Object)typeQuantity, (Binding)Bindings.STRING);
                            Layer0Utils.assert_((WriteGraph)graph, (Resource)declaredTypeResource, (Resource)FMI.Variable_quantity, (Resource)quantityValue);
                            Resource unitValue = graph.newResource();
                            graph.claim(unitValue, L0.InstanceOf, L0.String);
                            graph.claimValue(unitValue, (Object)typeUnit, (Binding)Bindings.STRING);
                            Layer0Utils.assert_((WriteGraph)graph, (Resource)declaredTypeResource, (Resource)FMI.Variable_unit, (Resource)unitValue);
                            graph.claim(this.typeLibrary, L0.ConsistsOf, L0.PartOf, declaredTypeResource);
                            this.declaredTypeMap.put(declaredType, declaredTypeResource);
                            if (type == 0) {
                                graph.claim(declaredTypeResource, L0.Inherits, FMI.RealVariable);
                            } else if (type == 1) {
                                graph.claim(declaredTypeResource, L0.Inherits, FMI.IntegerVariable);
                            } else if (type == 2) {
                                graph.claim(declaredTypeResource, L0.Inherits, FMI.BooleanVariable);
                            } else if (type == 3) {
                                graph.claim(declaredTypeResource, L0.Inherits, FMI.StringVariable);
                            }
                        }
                        Resource variable = graph.newResource();
                        if (declaredTypeResource != null) {
                            graph.claim(variable, L0.InstanceOf, declaredTypeResource);
                        } else if (type == 0) {
                            graph.claim(variable, L0.InstanceOf, FMI.RealVariable);
                        } else if (type == 1) {
                            graph.claim(variable, L0.InstanceOf, FMI.IntegerVariable);
                        } else if (type == 2) {
                            graph.claim(variable, L0.InstanceOf, FMI.BooleanVariable);
                        } else if (type == 3) {
                            graph.claim(variable, L0.InstanceOf, FMI.StringVariable);
                        }
                        if (declaredTypeResource != null) {
                            graph.claim(variable, L0.InstanceOf, declaredTypeResource);
                        }
                        graph.addLiteral(variable, L0.HasName, L0.NameOf, L0.String, (Object)parts[i], (Binding)Bindings.STRING);
                        graph.addLiteral(variable, FMI.Variable_description, FMI.Variable_description_Inverse, L0.String, (Object)description, (Binding)Bindings.STRING);
                        if (variability == 0) {
                            graph.claim(variable, FMI.Variable_variability, null, FMI.Variable_Variability_Constant);
                        } else if (variability == 1) {
                            graph.claim(variable, FMI.Variable_variability, null, FMI.Variable_Variability_Parameter);
                        } else if (variability == 2) {
                            graph.claim(variable, FMI.Variable_variability, null, FMI.Variable_Variability_Discrete);
                        } else if (variability == 3) {
                            graph.claim(variable, FMI.Variable_variability, null, FMI.Variable_Variability_Continuous);
                        } else if (variability == 4) {
                            graph.claim(variable, FMI.Variable_variability, null, FMI.Variable_Variability_Unknown);
                        }
                        if (causality == 0) {
                            graph.claim(variable, FMI.Variable_causality, null, FMI.Variable_Causality_Input);
                        } else if (causality == 1) {
                            graph.claim(variable, FMI.Variable_causality, null, FMI.Variable_Causality_Output);
                        } else if (causality == 2) {
                            graph.claim(variable, FMI.Variable_causality, null, FMI.Variable_Causality_Internal);
                        } else if (causality == 3) {
                            graph.claim(variable, FMI.Variable_causality, null, FMI.Variable_Causality_None);
                        } else if (causality == 4) {
                            graph.claim(variable, FMI.Variable_causality, null, FMI.Variable_Causality_Unknown);
                        }
                        graph.claim(parent.getResource(), L0.ConsistsOf, variable);
                    } else {
                        String folderId = String.valueOf(parent.getName()) + "." + parts[i];
                        Resource folder = map.get(folderId);
                        if (folder == null) {
                            folder = graph.newResource();
                            graph.claim(folder, L0.InstanceOf, FMI.Folder);
                            graph.addLiteral(folder, L0.HasName, L0.NameOf, L0.String, (Object)parts[i], (Binding)Bindings.STRING);
                            graph.claim(parent.getResource(), L0.ConsistsOf, folder);
                            map.put(folderId, folder);
                        }
                        parent = new NamedResource(folderId, folder);
                    }
                    ++i;
                }
            }

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                FMIStudioResource FMI = FMIStudioResource.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Resource model = FMIStudioSCL.createModel(graph, FMI.Model, target, modelName);
                graph.addLiteral(model, FMI.Model_fmuPath, FMI.Model_fmuPath_Inverse, L0.String, (Object)fmuPath, (Binding)Bindings.STRING);
                Resource configuration = graph.getSingleObject(model, SIMU.HasConfiguration);
                Resource experiment = graph.newResource();
                graph.claim(experiment, L0.InstanceOf, FMI.Experiment);
                graph.addLiteral(experiment, L0.HasName, L0.NameOf, L0.String, (Object)"Experiment", (Binding)Bindings.STRING);
                graph.claim(model, L0.ConsistsOf, experiment);
                this.typeLibrary = graph.newResource();
                graph.claim(this.typeLibrary, L0.InstanceOf, L0.Library);
                graph.addLiteral(this.typeLibrary, L0.HasName, L0.NameOf, L0.String, (Object)"Declared Types", (Binding)Bindings.STRING);
                graph.claim(model, L0.ConsistsOf, L0.PartOf, this.typeLibrary);
                Map map = (Map)((CollectionSupport)graph.getService(CollectionSupport.class)).createObjectResourceMap(String.class);
                int i = 0;
                while (i < variables.length) {
                    this.insert(graph, configuration, map, variables[i], descriptions[i], declaredTypes[i], types[i], variabilities[i], causalities[i]);
                    ++i;
                }
                return model;
            }
        });
    }
}

