/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.charts.ITrendSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.fmi.experiment.FMIExperiment;
import org.simantics.fmi.experiment.FMIExperimentDataFrame;
import org.simantics.fmi.experiment.FMINodeBase;
import org.simantics.fmi.experiment.IFMIExperiment;
import org.simantics.fmi.studio.core.Activator;
import org.simantics.fmi.studio.core.FMIDatasource;
import org.simantics.fmi.studio.core.TrendSupport;
import org.simantics.fmi.studio.core.WorkspaceUtil;
import org.simantics.fmi.studio.stubs.FMIStudioResource;
import org.simantics.fmil.core.FMILException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.experiment.IExperimentStatusListener;
import org.simantics.simulator.ExperimentState;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;
import org.simantics.simulator.toolkit.StandardExperimentStates;
import org.simantics.simulator.toolkit.db.ExperimentStateExternalRead;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIExperimentDB
implements IFMIExperiment,
IDynamicExperiment {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIExperimentDB.class);
    private FMIDatasource datasource;
    private TrendSupport trendSupport;
    private Resource run;
    private Resource model;
    private ExperimentStateExternalRead stateRead = new ExperimentStateExternalRead((Object)this);
    private IFMIExperiment fmiExperiment;

    private static String getIdentifierFromRun(ReadGraph graph, Resource run) throws DatabaseException {
        return (String)graph.getRelatedValue(run, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
    }

    private static Resource getRun(ReadGraph graph, String runURI) throws DatabaseException {
        return graph.getResource(runURI);
    }

    private static Resource getModel(ReadGraph graph, Resource run) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleIndexRoot(run));
    }

    public static File getFMUFile(ReadGraph graph, Resource model) throws DatabaseException {
        FMIStudioResource FMI = FMIStudioResource.getInstance((ReadGraph)graph);
        String fmuPath = (String)graph.getRelatedValue(model, FMI.Model_fmuPath, (Binding)Bindings.STRING);
        Path fmuFile = Activator.stateLocation().resolve(fmuPath);
        if (!Files.exists(fmuFile, new LinkOption[0])) {
            throw new DatabaseException("FMU file for " + fmuPath + " does not exist in " + fmuFile.toAbsolutePath());
        }
        return fmuFile.toFile();
    }

    public FMIExperimentDB(ReadGraph graph, String runURI) throws Exception {
        this(graph, FMIExperimentDB.getRun(graph, runURI));
    }

    public FMIExperimentDB(ReadGraph graph, Resource run) throws Exception {
        this(graph, FMIExperimentDB.getIdentifierFromRun(graph, run), run);
    }

    private FMIExperimentDB(ReadGraph graph, String id, Resource run) throws Exception {
        this(graph, id, run, FMIExperimentDB.getModel(graph, run), FMIExperimentDB.getHDF5Directory(graph, id, run));
    }

    private static File getHDF5Directory(ReadGraph graph, String id, Resource run) throws Exception {
        return WorkspaceUtil.getExperimentDirectory(graph, run, true, "hdf-" + id);
    }

    protected IFMIExperiment createExperiment(File workingDirectory, File fmuFile, String id) throws Exception {
        return new FMIExperiment(workingDirectory, fmuFile, id);
    }

    private FMIExperimentDB(ReadGraph graph, String id, Resource run, Resource model, File workingDirectory) throws Exception {
        this.fmiExperiment = this.createExperiment(workingDirectory, FMIExperimentDB.getFMUFile(graph, model), id);
        try {
            this.model = model;
            this.run = run;
            this.datasource = new FMIDatasource(this);
            this.fmiExperiment.addListener(new DynamicExperimentThreadListener(){

                public void afterStep() {
                    FMIExperimentDB.this.datasource.notifyStep();
                }

                public void stateChanged(ExperimentState newState) {
                    FMIExperimentDB.this.stateRead.fire();
                    if (StandardExperimentStates.Disposed.class.isInstance(newState)) {
                        FMIExperimentDB.this.doDispose();
                    }
                }
            });
            if (this.trendSupport != null) {
                this.trendSupport.dispose();
            }
            this.trendSupport = new TrendSupport(this);
            try {
                this.trendSupport.initializeHistoryCollection(graph);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize history collection and trending. See exception for details.", (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getService(Class<T> clazz) {
        if (ITrendSupport.class.equals(clazz)) {
            return (T)this.trendSupport;
        }
        return (T)this.fmiExperiment.getService(clazz);
    }

    public Resource getResource() {
        return this.run;
    }

    public Resource getModel() {
        return this.model;
    }

    protected void doDispose() {
        if (this.trendSupport != null) {
            this.trendSupport.dispose();
            this.trendSupport = null;
        }
        if (this.datasource != null) {
            this.datasource.dispose();
            this.datasource = null;
        }
    }

    public void addListener(IExperimentListener listener) {
        throw new IllegalStateException();
    }

    public void removeListener(IExperimentListener listener) {
        throw new IllegalStateException();
    }

    public void addStatusListener(IExperimentStatusListener listener) {
        throw new IllegalStateException();
    }

    public void removeStatusListener(IExperimentStatusListener listener) {
        throw new IllegalStateException();
    }

    public Lock getDatasourceLock() {
        throw new IllegalStateException();
    }

    public Accessor getAccessor() {
        throw new IllegalStateException();
    }

    public void refresh(Session session) {
        throw new IllegalStateException();
    }

    public void refresh(RequestProcessor session) {
        throw new IllegalStateException();
    }

    public void rewindTo(double time) {
        throw new IllegalStateException();
    }

    public void saveState() {
        throw new IllegalStateException();
    }

    public Datasource getDatasource() {
        return this.datasource;
    }

    private ExperimentState translateState(org.simantics.simulation.experiment.ExperimentState state) {
        switch (state) {
            case INITIALIZING: {
                return StandardExperimentStates.INITIALIZING;
            }
            case RUNNING: {
                return StandardExperimentStates.RUNNING;
            }
            case STOPPED: {
                return StandardExperimentStates.STOPPED;
            }
            case TO_BE_DISPOSED: {
                return StandardExperimentStates.TO_BE_DISPOSED;
            }
            case DISPOSED: {
                return StandardExperimentStates.DISPOSED;
            }
        }
        throw new IllegalStateException("Unsupported state: " + state);
    }

    private org.simantics.simulation.experiment.ExperimentState translateState(ExperimentState state) {
        if (state instanceof StandardExperimentStates.Initializing) {
            return org.simantics.simulation.experiment.ExperimentState.INITIALIZING;
        }
        if (state instanceof StandardExperimentStates.Running) {
            return org.simantics.simulation.experiment.ExperimentState.RUNNING;
        }
        if (state instanceof StandardExperimentStates.Stopped) {
            return org.simantics.simulation.experiment.ExperimentState.STOPPED;
        }
        if (state instanceof StandardExperimentStates.ToBeDisposed) {
            return org.simantics.simulation.experiment.ExperimentState.TO_BE_DISPOSED;
        }
        if (state instanceof StandardExperimentStates.Disposed) {
            return org.simantics.simulation.experiment.ExperimentState.DISPOSED;
        }
        throw new IllegalStateException("Unsupported state: " + state);
    }

    public void changeState(org.simantics.simulation.experiment.ExperimentState state) {
        this.fmiExperiment.changeStateL(this.translateState(state));
    }

    public org.simantics.simulation.experiment.ExperimentState getState() {
        return this.translateState(this.getStateL());
    }

    public org.simantics.simulation.experiment.ExperimentState getState(ReadGraph graph) throws DatabaseException {
        graph.syncRequest((ExternalRead)this.stateRead);
        return this.getState();
    }

    public void addListener(DynamicExperimentThreadListener listener) {
        this.fmiExperiment.addListener(listener);
    }

    public void removeListener(DynamicExperimentThreadListener listener) {
        this.fmiExperiment.removeListener(listener);
    }

    public FMINodeBase getRootNode() {
        return this.fmiExperiment.getRootNode();
    }

    public void changeStateL(ExperimentState state) {
        this.fmiExperiment.changeStateL(state);
    }

    public Map<String, FMINodeBase> getChildren(FMINodeBase node) {
        return this.fmiExperiment.getChildren((Object)node);
    }

    public FMIExperimentDataFrame getCurrentDataFrame() {
        return this.fmiExperiment.getCurrentDataFrame();
    }

    public Binding getEngineBinding(FMINodeBase node) throws NodeManagerException {
        return this.fmiExperiment.getEngineBinding((Object)node);
    }

    public Object getEngineValue(FMINodeBase node) throws NodeManagerException {
        return this.fmiExperiment.getEngineValue((Object)node);
    }

    public Object getEngineValueById(String id) throws NodeManagerException {
        return this.fmiExperiment.getEngineValueById(id);
    }

    public String getIdentifier() {
        return this.fmiExperiment.getIdentifier();
    }

    public String getName(FMINodeBase node) {
        return this.fmiExperiment.getName((Object)node);
    }

    public Map<String, FMINodeBase> getProperties(FMINodeBase node) {
        return this.fmiExperiment.getProperties((Object)node);
    }

    public double getSimulationTime() {
        return this.fmiExperiment.getSimulationTime();
    }

    public ExperimentState getStateL() {
        return this.fmiExperiment.getStateL();
    }

    public Collection<String> getVariables() {
        return this.fmiExperiment.getVariables();
    }

    public Object getVariableValueById(String id) {
        return this.fmiExperiment.getVariableValueById(id);
    }

    public Object getVariableValueById(String id, Binding binding) {
        return this.fmiExperiment.getVariableValueById(id, binding);
    }

    public boolean initializeSimulation() {
        return this.fmiExperiment.initializeSimulation();
    }

    public boolean isInitialized() {
        return this.fmiExperiment.isInitialized();
    }

    public void setEngineValue(FMINodeBase node, Object value) throws NodeManagerException {
        this.fmiExperiment.setEngineValue((Object)node, value);
    }

    public void setVariableValueById(String id, Object value, Binding binding) {
        this.fmiExperiment.setVariableValueById(id, value, binding);
    }

    public void shutdown(IProgressMonitor monitor) {
        this.fmiExperiment.shutdown(monitor);
    }

    public void simulate(boolean enabled) {
        this.fmiExperiment.simulate(enabled);
    }

    public void simulateDuration(double duration) {
        this.fmiExperiment.simulateDuration(duration);
    }

    public void simulateDurationSync(double duration) {
        this.fmiExperiment.simulateDurationSync(duration);
    }

    public boolean store(String id) throws FMILException {
        return this.fmiExperiment.store(id);
    }

    public boolean subscribe(String id) throws FMILException {
        return this.fmiExperiment.subscribe(id);
    }
}

