/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.strings;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class StringUtils {

    private static NumberFormat usFormat = DecimalFormat.getInstance(Locale.US);
    public final static String ZERO_LENGTH_STRING = ""; //$NON-NLS-1$

    /**
     * Ensures that a string is not null. Converts null strings into empty
     * strings, and leaves any other string unmodified. Use this to help
     * wrap calls to methods that return null instead of the empty string.
     * Can also help protect against implementation errors in methods that
     * are not supposed to return null. 
     * 
     * @param input input string (may be null)
     * @return input if not null, or the empty string if input is null
     */
    public static String safeString(String input) {
        if (input != null) {
            return input;
        }

        return ZERO_LENGTH_STRING;
    }
    

    public static double safeDouble(String input) {

        if(input == null) return Double.NaN;
        
        try {

            String usafied = input.replace(",", ".");
            Number number = usFormat.parse(usafied);
            return number.doubleValue();
            
        } catch (ParseException e) {
            
            return Double.NaN;
            
        }
        
    }
    
    public static String repeat(String pattern, int repeatCount)
    {
        StringBuilder sb = new StringBuilder(pattern.length() * repeatCount);
        for (int i=0; i<repeatCount; i++)
            sb.append(pattern);
        return sb.toString();
    }
    
}
