/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 16.12.2005
 * 
 */
package org.simantics.utils;


/**
 * DataContainer is used as return argument
 * 
 * 
 * @author Toni Kalajainen 
 */
public class ExtendableDataContainer<T> {

    private T data;
    
    public ExtendableDataContainer() {       
    }
    
    public ExtendableDataContainer(T initialData) {
        this.data = initialData;
    }
    
    public boolean isEmpty() {
        return data==null;
    }
    
    public void set(T value) {
        data = value;
    }
    
    public T get() {
        return data;
    }
    
    public boolean hasContent() {
    	return data!=null;
    }
    
    public static ExtendableDataContainer<Integer> getIntegerContainer() {
        return new ExtendableDataContainer<Integer>();
    }
        
    public static ExtendableDataContainer<Double> getDoubleContainer() {
        return new ExtendableDataContainer<Double>();
    }
        
    public static ExtendableDataContainer<String> getStringContainer() {
        return new ExtendableDataContainer<String>();
    }
        
}
