package org.simantics.spreadsheet.graph.parser.ast;

import java.util.ArrayList;

abstract public class AstList implements AstValue {

	public final AstValue left;

	public ArrayList<String> rightOps;
	public ArrayList<AstValue> rightValues;
	
	public AstList(AstValue left) {
		this.left = left;
	}
	
	public int rightCount() {
		if(rightValues == null) return 0;
		return rightValues.size();
	}
	
	public String rightOp(int index) {
		return rightOps.get(index);
	}
	
	public AstValue rightValue(int index) {
		return rightValues.get(index);
	}

	public void add(String op, AstValue value) {
		if(rightValues == null) {
			rightOps = new ArrayList<>(); 
			rightValues = new ArrayList<>();
		}
		rightOps.add(op);
		rightValues.add(value);
	}

	public AstValue simplify() {
		if(rightValues == null) return left;
		return this;
	}

}
