package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetMatrix;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;
import org.simantics.spreadsheet.graph.parser.ast.AstRange;

public class CountifFormulaFunction implements CellFormulaFunction<Integer> {

    @Override
    public Integer evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 2) throw new IllegalStateException();
        
        AstRange range = (AstRange) args.values.get(0);
        SpreadsheetMatrix matrix = (SpreadsheetMatrix) range.accept(visitor);
        Object crit = null;
        try {
        	crit = args.values.get(1).accept(visitor);
        } catch (IllegalStateException e){
        	return 0;
        }
        
        String criteria = SpreadsheetGraphUtils.asString(crit);
        int result = 0;
        for (Object value : matrix.values) {
            if (SpreadsheetGraphUtils.matchCriteria(value, criteria))
                result++;
        }
        return Integer.valueOf(result);
    }
}
