package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;

public class AndFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 0)
            throw new IllegalStateException();
        Boolean finalResult = Boolean.TRUE;
        for (int i = 0; i < args.values.size(); i++) {
        	Object res = (args.values.get(i).accept(visitor));
        	FormulaError2 err = FormulaError2.forObject(res);
        	if(err!=null) return err.getString();
        	
            if ((res instanceof Boolean && !((Boolean)res)) || !SpreadsheetGraphUtils.asBoolean(res))
                finalResult = Boolean.FALSE;
        }
        return finalResult;
    }
}