package org.simantics.spreadsheet.graph.celleditor;

import java.util.function.Consumer;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel.OperationMode;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class GraphCellEditorAdapter implements CellEditor<Write> {

    protected final Variable cell;

    public GraphCellEditorAdapter(Variable cell) {
        this.cell = cell;
    }
    
	public <T> void edit(WriteGraph graph, Transaction<Write> transaction, String location, String property, T value, Binding binding) throws DatabaseException {
		
	}
	
	public <T> void edit(WriteGraph graph, Transaction<Write> transaction, String location, Variant value) throws DatabaseException {
		
	}
	
	public <T> void copy(WriteGraph graph, Transaction<Write> transaction, String location, MutableVariant variant) throws DatabaseException {
		
	}

	@Override
	public <T> void edit(Transaction<Write> transaction, final String location, final String property, final T value, final Binding binding, Consumer<?> callback) {
		SpreadsheetUtils.schedule(transaction, new WriteRequest() {

			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
				edit(graph, transaction, location, property, value, binding);
				Layer0Utils.addCommentMetadata(graph, "Modified cell in location " + location + " with value " + value);
				if (callback != null)
				    callback.accept(null);
			}
			
		});
	}

	@Override
	public void edit(Transaction<Write> transaction, final String location, final Variant value, Consumer<?> callback) {
		SpreadsheetUtils.schedule(transaction, new WriteRequest() {

			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
				edit(graph, transaction, location, value);
				Layer0Utils.addCommentMetadata(graph, "Modified cell on location " + location + " with value " + value);
				if (callback != null)
				    callback.accept(null);
			}
			
		});
	}

	@Override
	public void copy(Transaction<Write> transaction, final String location, final MutableVariant variant, Consumer<?> callback) {
		SpreadsheetUtils.schedule(transaction, new WriteRequest() {

			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
				copy(graph, transaction, location, variant);
			}
			
		});
	}
	
	@Override
	public Transaction<Write> startTransaction(OperationMode mode) {
		return SpreadsheetUtils.startTransaction(mode);
	}

}
