/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Pair;

public class CellsExtended extends VariableRead<Collection<Pair<String, Variable>>> {

    public CellsExtended(Variable variable) {
        super(variable);
    }
    @Override
    public Collection<Pair<String, Variable>> perform(ReadGraph graph) throws DatabaseException {
    	
    	ArrayList<Pair<String, Variable>> cells = new ArrayList<>(graph.syncRequest(new Cells(variable)));
    	
    	Variable lines = variable.getPossibleChild(graph, "Lines");
    	if(lines != null) {
    		for(Variable line : graph.syncRequest(new Lines(lines))) {
    			cells.addAll(graph.syncRequest(new Cells(line)));
    		}
    	}
    	
    	return cells;
    	
    }

}
