package org.simantics.scl.ui.search;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.debug.ModuleDebugInfo;
import org.simantics.scl.compiler.module.debug.SymbolReference;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.db.SCLExpressionTableEntry;
import org.simantics.scl.db.UsedSCLExpressionsRequest;
import org.simantics.scl.osgi.SCLOsgi;

import gnu.trove.procedure.TObjectProcedure;

public class SCLSearchQuery implements ISearchQuery {

    private SCLSearchResult result;
    private String moduleName;
    private Name valueName;

    public SCLSearchQuery(Name valueName, String localModuleName) {
        this.valueName = valueName;
        this.moduleName = localModuleName;
    }
    
    @Override
    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        SCLSearchResult current = (SCLSearchResult) getSearchResult();
        current.removeAll();
        ModuleRepository repo = SCLOsgi.MODULE_REPOSITORY;
        Name localName = Name.create(moduleName, valueName.name);
        repo.getSourceRepository().forAllModules(new TObjectProcedure<String>() {
            
            @Override
            public boolean execute(String moduleName) {
                Failable<Module> failableModule = repo.getModule(moduleName);
                if (failableModule.didSucceed()) {
                    Module module = failableModule.getResult();
                    ModuleDebugInfo info = module.getModuleDebugInfo();
                    if (info != null) {
                        ArrayList<SymbolReference> results = info.symbolReferences;
                        for (SymbolReference ref : results) {
                            if (ref.referred.equals(valueName) || ref.referred.equals(localName)) {
                                result.addMatch(new Match(ref, Match.UNIT_LINE, -1, 1));
                            }
                        }
                    }
                }
                return true;
            }
        });
        
        Collection<SCLExpressionTableEntry> results = UsedSCLExpressionsRequest.execute();
        for (SCLExpressionTableEntry entry : results) {
            if (entry.getContent().contains(valueName.name)) {
                result.addMatch(new Match(entry, Match.UNIT_LINE, -1, 1));
            }
        }
        
        return Status.OK_STATUS;
    }

    @Override
    public String getLabel() {
        return "Search references for ";
    }

    @Override
    public boolean canRerun() {
        return true;
    }

    @Override
    public boolean canRunInBackground() {
        return true;
    }

    @Override
    public ISearchResult getSearchResult() {
        if (result == null) {
            result = new SCLSearchResult(this);
            new SearchResultUpdater(result);
        }
        return result;
    }

    public String getValueName() {
        return valueName.toString();
    }

}
