package org.simantics.scl.ui.outline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.scl.ui.editor2.SCLModuleEditor2;

public class SCLModuleOutlinePage extends Page implements IContentOutlinePage {

    private SCLOutlineViewer outlineViewer;
    private SCLModuleEditor2 moduleEditor;
    
    public SCLModuleOutlinePage(SCLModuleEditor2 moduleEditor) {
        this.moduleEditor = moduleEditor;
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (outlineViewer != null)
            outlineViewer.addSelectionChangedListener(listener);
    }

    @Override
    public ISelection getSelection() {
        if (outlineViewer != null)
            outlineViewer.getSelection();
        return StructuredSelection.EMPTY;
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (outlineViewer != null)
            outlineViewer.removeSelectionChangedListener(listener);
    }

    @Override
    public void setSelection(ISelection selection) {
        if (outlineViewer != null)
            outlineViewer.setSelection(selection);
    }

    @Override
    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, SWT.MULTI);
        outlineViewer = new SCLOutlineViewer(tree);
        
        SCLModuleOutlineProvider provider = new SCLModuleOutlineProvider();
        outlineViewer.setContentProvider(provider);
        outlineViewer.setLabelProvider(provider);
        
        outlineViewer.setInput(moduleEditor.getEditorInput());
    }

    @Override
    public Control getControl() {
        if (outlineViewer != null)
            outlineViewer.getControl();
        return null;
    }

    @Override
    public void setFocus() {
        if (outlineViewer != null)
            outlineViewer.getControl().setFocus();
    }

    protected class SCLOutlineViewer extends TreeViewer {

        public SCLOutlineViewer(Tree tree) {
            super(tree);
            setAutoExpandLevel(ALL_LEVELS);
            setUseHashlookup(true);
        }

        
    }
    
    protected class SCLModuleOutlineProvider implements ITreeContentProvider, ILabelProvider {

        @Override
        public Object[] getElements(Object inputElement) {
            return null;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            return null;
        }

        @Override
        public Object getParent(Object element) {
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            return false;
        }

        @Override
        public void addListener(ILabelProviderListener listener) {
            
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener listener) {
            
        }

        @Override
        public Image getImage(Object element) {
            return null;
        }

        @Override
        public String getText(Object element) {
            return null;
        }
        
        @Override
        public void dispose() {
            ITreeContentProvider.super.dispose();
        }

    }
}
