package org.simantics.scl.ui.modulebrowser;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.simantics.scl.compiler.module.repository.ModuleRepository;

public class SCLModuleTreeContentProvider implements ITreeContentProvider {
    private ModuleRepository repository;
    private final ModuleNameTreeEntry rootEntry = new ModuleNameTreeEntry(null, "", "");
    
    public void update() {
        rootEntry.clearModuleFlags();
        if(repository != null) {
            for(String moduleName : repository.getSourceRepository().getModuleNames()) {
                rootEntry.addModule(moduleName);
            }
        }
        rootEntry.prune();
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.repository = (ModuleRepository)newInput;
        update();
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return rootEntry.children();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        ModuleNameTreeEntry entry = (ModuleNameTreeEntry)parentElement;
        return entry.children();
    }

    @Override
    public Object getParent(Object element) {
        ModuleNameTreeEntry entry = (ModuleNameTreeEntry)element;
        return entry.parent;
    }

    @Override
    public boolean hasChildren(Object element) {
        ModuleNameTreeEntry entry = (ModuleNameTreeEntry)element;
        return !entry.childMap.isEmpty();
    }

    @Override
    public void dispose() {
    }

}
