package org.simantics.scl.ui.modulebrowser;

import java.util.Collection;
import java.util.Comparator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.osgi.framework.Bundle;
import org.simantics.scl.ui.Activator;

public class PluginSelectionDialog extends FilteredItemsSelectionDialog {

    private static final String PLUGIN_SELECTION_DIALOG = "PLUGIN_SELECTION_DIALOG";
    
    public static class Entry {
        Bundle bundle;
        int packageMatchLength;
        public Entry(Bundle bundle, int packageMatchLength) {
            this.bundle = bundle;
            this.packageMatchLength = packageMatchLength;
        }
    }
    Collection<Entry> entries;
    
    public PluginSelectionDialog(Shell shell, Collection<Entry> entries) {
        super(shell, true);
        this.entries = entries;
        setListLabelProvider(new LabelProvider() {
            @Override
            public String getText(Object element) {
                Entry entry = (Entry)element;
                if(entry == null)
                    return "NULL";
                return entry.bundle.getSymbolicName();
            }
        });
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = org.simantics.scl.ui.Activator.getInstance()
                .getDialogSettings().getSection(PLUGIN_SELECTION_DIALOG);
        if (settings == null)
            settings = Activator.getInstance()
            .getDialogSettings().addNewSection(PLUGIN_SELECTION_DIALOG);
        return settings;
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ItemsFilter() {
            {
                String patternText = getPattern();
                patternMatcher = new SearchPattern();
                if(patternText != null && patternText.length() > 0)
                    patternMatcher.setPattern(patternText);
                else 
                    patternMatcher.setPattern("*");
            }
            
            @Override
            public boolean matchItem(Object item) {
                Entry entry = (Entry)item;
                String name = entry.bundle.getSymbolicName();
                if(getPattern().indexOf('/') > 0)
                    return matches(name);
                else {
                    for(String part : name.split("/"))
                        if(matches(part))
                            return true;
                    return false;
                }
            }

            @Override
            public boolean isConsistentItem(Object item) {
                return true;
            }
            
        };
    }

    Comparator<Entry> comparator = new Comparator<Entry>() {
        @Override
        public int compare(Entry o1, Entry o2) {
            if(o1.packageMatchLength != o2.packageMatchLength)
                return Integer.compare(o2.packageMatchLength, o1.packageMatchLength);
            return o1.bundle.getSymbolicName().compareTo(o2.bundle.getSymbolicName());
        }
    };
    
    @SuppressWarnings("rawtypes")
    @Override
    protected Comparator getItemsComparator() {
        return comparator;
    }

    @Override
    protected void fillContentProvider(final AbstractContentProvider contentProvider,
            final ItemsFilter itemsFilter, IProgressMonitor progressMonitor)
            throws CoreException {
        for(Entry entry : entries)
            contentProvider.add(entry, itemsFilter);
        if(progressMonitor != null)
            progressMonitor.done();
    }

    @Override
    public String getElementName(Object item) {
        Entry entry = (Entry)item;
        return entry.bundle.getSymbolicName();
    }

}
