package org.simantics.scl.ui.modulebrowser;

public class CreateModuleValidator {
    public static boolean isValidPackageName(String packageName) {
        if(packageName.isEmpty())
            return true;
        for(String part : packageName.split("/", -1))
            if(!isValidModuleName(part))
                return false;
        return true;
    }

    public static boolean isValidModuleName(String moduleName) {
        if(moduleName.isEmpty())
            return false;
        {
            char c = moduleName.charAt(0);
            if(!Character.isLetter(c))
                return false;
        }
        for(int i=1;i<moduleName.length();++i) {
            char c = moduleName.charAt(i);
            if(!Character.isLetter(c) && !Character.isDigit(c) && c != '_')
                return false;
        }
        return true;
    }
}
