package org.simantics.scl.ui.editor2;

import java.util.Comparator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;

import gnu.trove.procedure.TObjectProcedure;

public class SCLModuleSelectionDialog extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "SCLModuleSelectionDialogSettings";

    public SCLModuleSelectionDialog(Shell shell) {
        super(shell, false);
        setTitle("Choose an SCL module");
        setSelectionHistory(new ModuleSelectionHistory());
        setListLabelProvider(new LabelProvider() {
            @Override
            public String getText(Object element) {
                if(element == null)
                    return "";
                return (String)element;
            }
        });
    }

    private class ModuleSelectionHistory extends SelectionHistory {
        protected Object restoreItemFromMemento(IMemento element) {
            //return element.getString("resource"); //$NON-NLS-1$
            return null;
        }
        protected void storeItemToMemento(Object item, IMemento element) {
            //element.putString("resource", item.toString()); //$NON-NLS-1$
        }
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
         IDialogSettings settings = Activator.getInstance().getDialogSettings().getSection(DIALOG_SETTINGS);
         if (settings == null)
             settings = Activator.getInstance().getDialogSettings().addNewSection(DIALOG_SETTINGS);
         return settings;
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ItemsFilter() {
            {
                String patternText = getPattern();
                patternMatcher = new SearchPattern();
                if(patternText != null && patternText.length() > 0)
                    patternMatcher.setPattern(patternText);
                else 
                    patternMatcher.setPattern("*");
            }
            
            @Override
            public boolean matchItem(Object item) {
                String text = item.toString();
                if(getPattern().contains("/"))
                    return matches(text);
                else {
                    int p = text.lastIndexOf('/');
                    if(p >= 0)
                        text = text.substring(p+1);
                    return matches(text);
                }
            }

            @Override
            public boolean isConsistentItem(Object item) {
                return true;
            }
            
        };
    }

    @SuppressWarnings("rawtypes")
    @Override
    protected Comparator getItemsComparator() {
        return new Comparator() {
            public int compare(Object arg0, Object arg1) {
                String a = (String)arg0;
                String b = (String)arg1;
                return a.compareTo(b);
            }
        };
    }

    @Override
    protected void fillContentProvider(AbstractContentProvider contentProvider,
            ItemsFilter itemsFilter, IProgressMonitor progressMonitor)
                    throws CoreException {
        progressMonitor.beginTask("Searching", 1); //$NON-NLS-1$
        SCLOsgi.SOURCE_REPOSITORY.forAllModules(new TObjectProcedure<String>() {
            @Override
            public boolean execute(String moduleName) {
                contentProvider.add(moduleName, itemsFilter);
                return true;
            }
        });
        progressMonitor.worked(1);
        progressMonitor.done();
    }

    @Override
    public String getElementName(Object item) {
        return item.toString();
    }

}
