package org.simantics.scl.ui.editor;

import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.simantics.scl.ui.info.SCLInfo;

public class SCLSourceViewerConfiguration extends SourceViewerConfiguration {

    ColorManager colorManager;
    
    public SCLSourceViewerConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }
    
    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(SCLDocumentSetup.SCL_PARTIONING);
        
        {
            final Token string = new Token(new TextAttribute(colorManager.get(new RGB(42, 0, 255))));            
            RuleBasedScanner scanner = new RuleBasedScanner();
            scanner.setDefaultReturnToken(string);
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
            reconciler.setRepairer(dr, SCLDocumentSetup.STRING);
            reconciler.setDamager(dr, SCLDocumentSetup.STRING);
        }
        
        {
            Token comment = new Token(new TextAttribute(colorManager.get(new RGB(63, 127, 95))));            
            RuleBasedScanner scanner = new RuleBasedScanner();
            scanner.setDefaultReturnToken(comment);
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
            reconciler.setRepairer(dr, SCLDocumentSetup.COMMENT);
            reconciler.setDamager(dr, SCLDocumentSetup.COMMENT);
        }
        
        {
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(getSclTokenScanner());        
            reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);
            reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
        }
        
        return reconciler;
    }

    private ITokenScanner getSclTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
       
        final Token reserved = new Token(new TextAttribute(colorManager.get(new RGB(127, 0, 85)), null, SWT.BOLD));

        WordRule reservedWord = new WordRule(new IWordDetector() {          
            @Override
            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }
            
            @Override
            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, new Token(new TextAttribute(colorManager.get(new RGB(0, 0, 0)))));

        for(String word : SCLInfo.RESERVED_WORDS)
            reservedWord.addWord(word, reserved);
                
        IRule[] rules = new IRule[] {
                reservedWord,
                new WhitespaceRule(new IWhitespaceDetector() {
                    
                    @Override
                    public boolean isWhitespace(char c) {
                        return Character.isWhitespace(c);
                    }
                }),
        };
        scanner.setRules(rules);
        
        return scanner;     
    }
    
    @Override
    public IAutoEditStrategy[] getAutoEditStrategies(
            ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[] { 
                new ReplaceTabsBySpaces(),
                new DefaultIndentLineAutoEditStrategy()/*,
                new MatchingBracketsEditStrategy()*/
        };
    }
}
