package org.simantics.scl.ui.console;

import org.eclipse.jface.action.Action;
import org.simantics.scl.ui.Activator;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
class ConsoleActions {

    public static Action createInterruptAction(SCLConsole console) {
        Action interruptAction = new Action("Interrupt current command",
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/stop.png")) {
            @Override
            public void run() {
                console.interruptCurrentCommands();
            }
        };
        interruptAction.setDisabledImageDescriptor(
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/stop_disabled.png"));
        interruptAction.setEnabled(false);
        return interruptAction;
    }

    public static Action createClearAction(SCLConsole console) {
        Action clearAction = new Action("Clear console",
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/clear_console.png")) {
            @Override
            public void run() {
                setEnabled(false);
                console.clear();
            }
        };
        clearAction.setDisabledImageDescriptor(
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/clear_console_disabled.png"));
        clearAction.setEnabled(false);
        return clearAction;
    }

}
