package org.simantics.scl.ui.assist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.types.Type;


public class SCLContentProposalProvider implements IContentProposalProvider {

    private final CommandSession session;

    public SCLContentProposalProvider(CommandSession session) {
        this.session = session;
    }

    @Override
    public IContentProposal[] getProposals(String contents, int position) {
        int startPos = getPrefixStartPos(contents, position);
        String prefix = contents.substring(startPos, position);
        int prefixLength = prefix.length();
        int namespaceLength = prefix.indexOf('.');
        if(namespaceLength < 0)
            namespaceLength = 0;
        else
            ++namespaceLength;
        
        List<SCLValue> values = Environments.findValuesForPrefix(
                session.getRuntimeEnvironment().getEnvironment(),
                prefix);
        
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        for(SCLValue value : values)
            if(!value.isPrivate() && !(value.getName().name.contains("$") &&
                    Character.isLetter(value.getName().name.charAt(0))))
                proposals.add(new SCLContentProposal(value));
        
        prefix = prefix.toLowerCase();
        for(Map.Entry<String,Type> entry : session.localNamesForContentProposals().entrySet())
            if(entry.getKey().toLowerCase().startsWith(prefix))
                proposals.add(new SCLContentProposal(entry.getKey(), "LocalEnvironment", entry.getValue()));
        
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }
    
    private static int getPrefixStartPos(String contents, int position) {
        int pos = position;
        while(pos > 0) {
            char c = contents.charAt(pos-1);
            if(Character.isJavaIdentifierPart(c) || c == '.')
                --pos;
            else
                break;
        }
        return pos;
    }
}