package org.simantics.issues;

/**
 * Issue severities, from most severe to the least severe.
 */
public enum Severity {
    FATAL, ERROR, WARNING, INFO, NOTE, UNKNOWN;

    public static Severity moreSevere(Severity s1, Severity s2) {
        if (s1 == null)
            return s2;
        if (s2 == null)
            return s1;
        return (s1.ordinal() < s2.ordinal()) ? s1 : s2;
    }
}