/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.impl;

import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.DoubleBindingDefault;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.CollectorState;
import org.simantics.history.impl.FlushPolicy;
import org.simantics.history.util.ValueBand;
import org.simantics.history.util.WeightedMedian;
import org.simantics.history.util.subscription.SubscriptionItem;

public class CollectorImpl
implements Collector {
    static Logger logger = Logger.getLogger(CollectorImpl.class.getName());
    public static final int MEDIAN_LIMIT = 500;
    public static final double EPSILON = 0.01;
    CollectorState state;
    CopyOnWriteArrayList<ActiveStream> items = new CopyOnWriteArrayList();
    HistoryManager history;
    boolean itemsOpen = true;
    public FlushPolicy flushPolicy = FlushPolicy.FlushOnEveryStep;

    @Override
    public FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @Override
    public void setFlushPolicy(FlushPolicy flushPolicy) {
        this.flushPolicy = flushPolicy;
    }

    public CollectorImpl(HistoryManager history) {
        this.history = history;
        this.state = new CollectorState();
        this.state.init();
        this.state.id = UUID.randomUUID().toString();
    }

    public CollectorImpl(HistoryManager history, CollectorState previousState) {
        this.history = history;
        this.state = (CollectorState)previousState.clone();
    }

    @Override
    public synchronized void addItem(Bean item) throws HistoryException {
        try {
            String id = (String)item.getField("id");
            CollectorState.Item itemState = null;
            if (item.hasField("collectorState")) {
                itemState = (CollectorState.Item)((Object)item.getField("collectorState", CollectorState.BINDING_ITEM));
            }
            if (itemState == null) {
                itemState = this.state.itemStates.get(id);
            }
            if (itemState == null) {
                itemState = new CollectorState.Item();
                itemState.init();
                itemState.readAvailableFields(item);
                if (this.history.exists(id)) {
                    CollectorImpl.readItemState(this.history, item, itemState);
                }
            }
            this.addItem(id, itemState);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    public synchronized void addItem(String id, CollectorState.Item itemState) throws HistoryException {
        try {
            this.state.itemStates.put(id, itemState);
            this.itemsOpen = false;
            if (this.state.time.type() instanceof NumberType) {
                double time = (Double)Bindings.adapt((Object)this.state.time.getValue(), (Binding)this.state.time.getBinding(), (Binding)Bindings.DOUBLE);
                if (!Double.isNaN(itemState.currentTime) && itemState.currentTime > time) {
                    this.state.time.setValue((Binding)Bindings.DOUBLE, (Object)itemState.currentTime);
                }
            }
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public synchronized void addItems(Bean ... items) throws HistoryException {
        Bean[] beanArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Bean item = beanArray[n2];
            this.addItem(item);
            ++n2;
        }
    }

    @Override
    public synchronized void removeItem(String id) throws HistoryException {
        ActiveStream as;
        CollectorState.Item itemState = this.state.itemStates.remove(id);
        if (itemState != null && this.history.exists(id)) {
            Bean bean = this.history.getItem(id);
            bean.readAvailableFields((Bean)itemState);
            try {
                bean = CollectorImpl.setItemState(bean, itemState);
                this.history.modify(bean);
            }
            catch (BindingException e) {
                logger.log(Level.FINE, "Failed to update bean", e);
            }
            catch (BindingConstructionException e) {
                logger.log(Level.FINE, "Failed to update bean", e);
            }
            catch (HistoryException e) {
                logger.log(Level.FINE, "Failed to update history item meta-data", e);
            }
        }
        if ((as = this.getStream(id)) != null) {
            this.items.remove(as);
            as.close();
        }
    }

    ActiveStream getStream(String id) {
        for (ActiveStream as : this.items) {
            if (!as.itemState.id.equals(id)) continue;
            return as;
        }
        return null;
    }

    @Override
    public synchronized void setItem(Bean item) throws HistoryException {
        try {
            String id = (String)item.getField("id");
            CollectorState.Item itemState = this.state.itemStates.get(id);
            if (itemState == null) {
                this.addItem(item);
                return;
            }
            itemState.readAvailableFields(item);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    public static Bean setItemState(Bean config, CollectorState.Item state) throws BindingException, BindingConstructionException {
        Binding binding = config.getFieldBinding("collectorState");
        if (binding == null || !binding.type().equals((Object)CollectorState.BINDING_ITEM.type())) {
            RecordType rt = config.getBinding().type();
            RecordType newType = new RecordType();
            int i = 0;
            while (i < rt.getComponentCount()) {
                Component c = rt.getComponent(i);
                if (!c.name.equals("collectorState")) {
                    newType.addComponent(c.name, c.type);
                }
                ++i;
            }
            newType.addComponent("collectorState", CollectorState.BINDING_ITEM.type());
            Binding newBinding = Bindings.getBeanBinding((Datatype)newType);
            Bean newConfig = (Bean)newBinding.createDefault();
            newConfig.readAvailableFields(config);
            config = newConfig;
        }
        config.setField("collectorState", CollectorState.BINDING_ITEM, (Object)state);
        return config;
    }

    @Override
    public SubscriptionItem[] getItems() {
        int c = this.state.itemStates.size();
        SubscriptionItem[] items = new SubscriptionItem[c];
        int ix = 0;
        Serializer s = Bindings.getSerializerUnchecked((Binding)CollectorState.BINDING_ITEM);
        for (CollectorState.Item item : this.state.itemStates.values()) {
            _HistoryItem hi = new _HistoryItem();
            hi.init();
            hi.readAvailableFields(item);
            try {
                byte[] data = s.serialize((Object)item);
                hi.collectorState = (CollectorState.Item)((Object)s.deserialize(data));
            }
            catch (IOException iOException) {}
            items[ix++] = hi;
        }
        return items;
    }

    ActiveStream openStream(CollectorState.Item itemState) throws HistoryException {
        Datatype sampleType;
        ActiveStream x = new ActiveStream();
        x.itemState = itemState;
        if (!this.history.exists(x.itemState.id)) {
            throw new HistoryException("TimeSeries " + x.itemState.id + " does not exist.");
        }
        x.stream = this.history.openStream(x.itemState.id, "rw");
        itemState.format = sampleType = x.stream.type().componentType;
        try {
            x.binding = (RecordBinding)Bindings.getBeanBinding((Datatype)sampleType);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Could not create bean binding for type " + sampleType);
            x.binding = (RecordBinding)Bindings.getBinding((Datatype)sampleType);
        }
        x.valueBinding = x.binding.getComponentBinding("value");
        x.isNumeric = x.valueBinding instanceof NumberBinding;
        boolean bl = x.hasEndTime = x.binding.getComponentIndex("endTime") > 0;
        if (x.isNumeric) {
            try {
                x.valueToDouble = Bindings.adapterFactory.getAdapter(x.valueBinding, (Binding)Bindings.DOUBLE, true, false);
                x.doubleToValue = Bindings.adapterFactory.getAdapter((Binding)Bindings.DOUBLE, x.valueBinding, true, false);
            }
            catch (AdapterConstructionException adapterConstructionException) {
                x.valueToDouble = null;
            }
        }
        try {
            Object currentEntry = x.binding.createDefault();
            if (x.stream.size() >= 1) {
                x.stream.get(x.stream.size() - 1, (Binding)x.binding, currentEntry);
            }
            x.current = new ValueBand((Binding)x.binding);
            x.current.setSample(currentEntry);
        }
        catch (AccessorException e) {
            throw new HistoryException("Could not read sample from stream file, " + (Object)((Object)e), e);
        }
        catch (BindingException e) {
            throw new HistoryException("Could not read sample from stream file, " + (Object)((Object)e), e);
        }
        x.itemState = itemState;
        if (x.isNumeric && x.current.hasMedian() && x.itemState.median == null) {
            x.itemState.median = new WeightedMedian(500);
        }
        return x;
    }

    static void readItemState(HistoryManager history, Bean si, CollectorState.Item item) throws RuntimeBindingException, HistoryException {
        item.readAvailableFields(si);
        StreamAccessor sa = history.openStream(item.id, "r");
        try {
            try {
                Datatype sampleType = sa.type().componentType;
                Binding sampleBinding = Bindings.getBinding((Datatype)sampleType);
                if (!sampleType.equals((Object)item.format)) {
                    throw new HistoryException("Could not create subscription, item \"" + item.id + "\" already exists and has wrong format (" + sampleType + " vs. " + item.format + ")");
                }
                Object sample = sampleBinding.createDefaultUnchecked();
                ValueBand v = new ValueBand(sampleBinding, sample);
                item.count = sa.size();
                if (item.count > 0) {
                    sa.get(0, sampleBinding, sample);
                    item.firstTime = v.getTimeDouble();
                    Binding b = v.getValueBinding();
                    Object value = v.getValue(b);
                    item.firstValue.setValue(b, value);
                    sa.get(item.count - 1, sampleBinding, sample);
                    item.currentTime = v.getTimeDouble();
                    b = v.getValueBinding();
                    value = v.getValue(b);
                    item.currentValue.setValue(b, value);
                    if (item.currentValue.getBinding() instanceof DoubleBinding) {
                        DoubleBinding db = (DoubleBinding)item.currentValue.getBinding();
                        value = item.currentValue.getValue((Binding)db);
                        item.isNaN = Double.isNaN((Double)value);
                    }
                }
            }
            catch (AccessorException e) {
                throw new HistoryException(e);
            }
            catch (AdaptException e) {
                throw new HistoryException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                sa.close();
            }
            catch (AccessorException accessorException) {}
            throw throwable;
        }
        try {
            sa.close();
        }
        catch (AccessorException accessorException) {}
    }

    @Override
    public CollectorState getState() {
        return (CollectorState)this.state.clone();
    }

    @Override
    public void setState(Bean newState) {
        if (newState == null) {
            return;
        }
        if (this.state == null) {
            this.state = new CollectorState();
            this.state.init();
        }
        this.state.readAvailableFields(newState);
        this.itemsOpen = false;
    }

    @Override
    public Object getTime(Binding binding) throws HistoryException {
        MutableVariant v = this.state.time;
        if (v == null) {
            return null;
        }
        try {
            return v.getValue(binding);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public Object getValue(String id, Binding binding) throws HistoryException {
        CollectorState.VariableState vs = this.state.values.get(id);
        if (vs == null) {
            return null;
        }
        if (!vs.isValid) {
            return null;
        }
        try {
            return vs.value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new HistoryException(e);
        }
    }

    void openAllItems() throws HistoryException {
        if (this.itemsOpen) {
            return;
        }
        THashSet itemsToOpen = new THashSet(this.state.itemStates.keySet());
        for (ActiveStream as : this.items) {
            itemsToOpen.remove(as.itemState.id);
        }
        ArrayList<ActiveStream> opened = new ArrayList<ActiveStream>(itemsToOpen.size());
        for (String itemId : itemsToOpen) {
            CollectorState.Item item = this.state.itemStates.get(itemId);
            ActiveStream as = this.openStream(item);
            opened.add(as);
        }
        this.items.addAll(opened);
        this.itemsOpen = true;
    }

    private void updateDt(NumberBinding binding, Object time) {
        try {
            Double current = (Double)this.getTime((Binding)Bindings.DOUBLE);
            if (current != null) {
                double t = binding.getValue(time).doubleValue();
                this.state.dT = t - current;
                if (this.state.dT > 0.0) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {}
        this.state.dT = 1.0;
    }

    @Override
    public void beginStep(NumberBinding binding, Object time) throws HistoryException {
        this.openAllItems();
        this.updateDt(binding, time);
        this.state.time.setValue((Binding)binding, time);
    }

    @Override
    public void setValue(String id, Binding binding, Object value) throws HistoryException {
        CollectorState.VariableState vs = this.state.values.get(id);
        if (vs == null) {
            vs = new CollectorState.VariableState();
            vs.value = new MutableVariant(binding, value);
            this.state.values.put(id, vs);
        }
        if (value == null) {
            vs.value.setValue(VoidBinding.VOID_BINDING, null);
            vs.isNan = true;
            vs.isValid = false;
            return;
        }
        vs.value.setValue(binding, value);
        vs.isValid = true;
        if (binding instanceof DoubleBinding) {
            DoubleBinding db = (DoubleBinding)binding;
            try {
                double _v = db.getValue_(value);
                vs.isNan = Double.isNaN(_v);
            }
            catch (BindingException bindingException) {
                vs.isNan = true;
                vs.isValid = false;
            }
        } else if (binding instanceof FloatBinding) {
            FloatBinding db = (FloatBinding)binding;
            try {
                float _v = db.getValue_(value);
                vs.isNan = Float.isNaN(_v);
            }
            catch (BindingException bindingException) {
                vs.isNan = true;
                vs.isValid = false;
            }
        } else {
            vs.isNan = false;
        }
    }

    @Override
    public boolean getValue(String id, MutableVariant result) {
        CollectorState.VariableState vs = this.state.values.get(id);
        if (vs == null) {
            return false;
        }
        if (!vs.isValid) {
            return false;
        }
        result.setValue(vs.value.getBinding(), vs.value.getValue());
        return true;
    }

    @Override
    public void endStep() throws HistoryException {
        for (ActiveStream i : this.items) {
            try {
                this.putValueToStream(i);
                if (this.flushPolicy != FlushPolicy.FlushOnEveryStep) continue;
                i.stream.flush();
            }
            catch (AdaptException e) {
                throw new HistoryException(e);
            }
            catch (AccessorException e) {
                throw new HistoryException(e);
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
        }
    }

    private int sampleNum(double time, double interval) {
        return (int)(1.0 + (time + 0.01 * this.state.dT) / interval);
    }

    private boolean isExactInterval(double time, double interval) {
        return this.sampleNum(time, interval) > this.sampleNum(time - 0.02 * this.state.dT, interval);
    }

    private void putValueToStream(ActiveStream i) throws AdaptException, AccessorException, BindingException, HistoryException {
        boolean condition;
        boolean makeNewBand;
        boolean isMinMaxFormat;
        double currentValueDouble;
        MutableVariant value;
        boolean isValidValue;
        boolean isNanValue;
        MutableVariant time = this.state.time;
        double currentTime = Double.NaN;
        if (time != null) {
            Double x = (Double)time.getValue((Binding)Bindings.DOUBLE);
            currentTime = x == null ? Double.NaN : x;
        }
        boolean isFirstValue = i.stream.size() == 0;
        boolean isDisabled = !i.itemState.enabled;
        boolean wasDisabled = !isFirstValue && i.itemState.isDisabled;
        i.itemState.isDisabled = isDisabled;
        if (isDisabled) {
            ++i.itemState.count;
            i.itemState.lastDisabledTime = currentTime;
            if (!wasDisabled) {
                i.itemState.firstDisabledTime = currentTime;
            }
            return;
        }
        CollectorState.VariableState vs = this.state.values.get(i.itemState.variableId);
        if (vs != null) {
            isNanValue = vs.isNan;
            isValidValue = vs.isValid;
            value = vs.value;
            if (i.isNumeric && isValidValue && !isNanValue) {
                currentValueDouble = (Double)value.getValue((Binding)Bindings.DOUBLE);
                if (i.itemState.gain != 1.0 || i.itemState.bias != 0.0) {
                    currentValueDouble = i.itemState.gain * currentValueDouble + i.itemState.bias;
                    Double x = i.valueBinding instanceof DoubleBindingDefault ? Double.valueOf(currentValueDouble) : i.doubleToValue.adapt((Object)currentValueDouble);
                    value = new MutableVariant(i.valueBinding, (Object)x);
                }
            } else {
                currentValueDouble = Double.NaN;
            }
        } else {
            isNanValue = true;
            isValidValue = false;
            value = new MutableVariant(i.valueBinding, i.valueBinding.createDefault());
            currentValueDouble = Double.NaN;
        }
        double prevValueDouble = Double.NaN;
        MutableVariant pv = i.itemState.currentValue;
        prevValueDouble = pv != null && pv.getBinding() instanceof NumberBinding ? (Double)pv.getValue((Binding)Bindings.DOUBLE) : Double.NaN;
        double firstTime = i.itemState.firstTime;
        double prevTime = i.itemState.currentTime;
        boolean restep = prevTime == currentTime;
        boolean isNaNChange = i.itemState.isNaN ^ isNanValue;
        boolean isValidChange = i.itemState.isValid ^ isValidValue;
        boolean hasInterval = !Double.isNaN(i.itemState.interval) && i.itemState.interval > Double.MIN_VALUE;
        boolean hasDeadband = !Double.isNaN(i.itemState.deadband) && i.itemState.deadband > Double.MIN_VALUE && i.isNumeric;
        boolean bl = isMinMaxFormat = i.itemState.interval == Double.MAX_VALUE && i.itemState.deadband == Double.MAX_VALUE && i.binding.getComponentIndex("min") >= 0 && i.binding.getComponentIndex("max") >= 0;
        if (isValidValue && i.isNumeric && i.itemState.count >= 1) {
            if (i.itemState.isValid) {
                double firstValueDouble = (Double)i.itemState.firstValue.getValue((Binding)Bindings.DOUBLE);
                double diff = Math.abs(currentValueDouble - firstValueDouble);
                i.itemState.ooDeadband = hasDeadband ? i.itemState.ooDeadband | diff >= i.itemState.deadband : i.itemState.ooDeadband | diff != 0.0;
            } else {
                i.itemState.ooDeadband = true;
            }
            i.itemState.ooDeadband |= isNaNChange;
        } else {
            i.itemState.ooDeadband = false;
        }
        boolean ooInterval = true;
        if (hasInterval) {
            int sn1;
            if (isFirstValue) {
                int sn2;
                if (Double.isNaN(i.itemState.firstTime)) {
                    firstTime = i.itemState.firstTime = currentTime;
                }
                if ((sn1 = this.sampleNum(firstTime, i.itemState.interval)) == (sn2 = this.sampleNum(currentTime, i.itemState.interval)) && !this.isExactInterval(currentTime, i.itemState.interval) && !isMinMaxFormat) {
                    return;
                }
            } else {
                sn1 = this.sampleNum(prevTime, i.itemState.interval);
                int sn2 = this.sampleNum(currentTime, i.itemState.interval);
                ooInterval = sn2 > sn1;
            }
        }
        boolean bl2 = makeNewBand = i.itemState.ooDeadband && isValidValue && ooInterval || isFirstValue || wasDisabled || isValidChange;
        if (isValidValue && i.isNumeric) {
            if (i.current.hasAvg() && i.isNumeric) {
                if (Double.isNaN(i.itemState.sum)) {
                    i.itemState.sum = 0.0;
                }
                if (isValidValue && i.isNumeric) {
                    double timeDelta = currentTime - i.itemState.currentTime;
                    i.itemState.sum += timeDelta * currentValueDouble;
                }
            }
            if (i.current.hasMedian() && !Double.isNaN(prevValueDouble)) {
                double deltaTime = currentTime - prevTime;
                i.itemState.median.add(deltaTime, prevValueDouble);
            }
        }
        if (!restep) {
            ++i.itemState.count;
        }
        i.itemState.currentTime = currentTime;
        i.itemState.currentValue.readFrom(value.getBinding(), value.getValue());
        i.itemState.isNaN = isNanValue;
        i.itemState.isValid = isValidValue;
        if (wasDisabled && i.current.supportsNullValue()) {
            if (i.current.isNullValue()) {
                if (i.current.hasEndTime()) {
                    i.current.setEndTime((Binding)Bindings.DOUBLE, i.itemState.lastDisabledTime);
                }
                if (i.current.hasCount()) {
                    i.current.setCount(i.current.getCount() + 1);
                }
                i.stream.setNoflush(i.stream.size() - 1, (Binding)i.binding, i.current.getSample());
            }
            i.current.reset();
            i.current.setValueNull();
            i.current.setTime((Binding)Bindings.DOUBLE, i.itemState.firstDisabledTime);
            i.current.setEndTime((Binding)Bindings.DOUBLE, i.itemState.lastDisabledTime);
            i.stream.addNoflush((Binding)i.binding, i.current.getSample());
        }
        boolean bl3 = condition = makeNewBand || !i.hasEndTime && i.itemState.count == 2;
        if (i.stream.size() > 0) {
            if (!i.hasEndTime) {
                i.current.setTime(time.getBinding(), time.getValue());
            } else {
                i.current.setEndTime(time.getBinding(), time.getValue());
            }
            if (i.itemState.ooDeadband || isMinMaxFormat) {
                if (isValidValue) {
                    if (i.current.hasLastValue()) {
                        i.current.setLastValue(value.getBinding(), value.getValue());
                    }
                    if (i.isNumeric && !isNanValue) {
                        Object currentValueWithMaxBinding;
                        Object prevMaxValue;
                        Binding maxBinding;
                        Object currentValueWithMinBinding;
                        Object prevMinValue;
                        Binding minBinding;
                        int diff;
                        if (i.current.hasAvg() && !restep) {
                            double duration = currentTime - i.itemState.firstTime;
                            if (duration < 1.0E-9) {
                                i.current.setAvg((Binding)Bindings.DOUBLE, 0.0);
                            } else {
                                i.current.setAvg((Binding)Bindings.DOUBLE, i.itemState.sum / duration);
                            }
                        }
                        if (i.current.hasMin() && (diff = (minBinding = i.current.getMinBinding()).compare(prevMinValue = i.current.getMin(), currentValueWithMinBinding = value.getValue(minBinding))) > 0) {
                            i.current.setMin(minBinding, currentValueWithMinBinding);
                        }
                        if (i.current.hasMax() && (diff = (maxBinding = i.current.getMaxBinding()).compare(prevMaxValue = i.current.getMax(), currentValueWithMaxBinding = value.getValue(maxBinding))) < 0) {
                            i.current.setMax(maxBinding, currentValueWithMaxBinding);
                        }
                        if (i.current.hasMedian()) {
                            Double median = i.itemState.median.getMedian();
                            i.current.setMedian((Binding)Bindings.DOUBLE, median);
                        }
                    }
                } else {
                    i.current.setValueNull();
                }
                if (i.current.hasCount()) {
                    i.current.setCount(i.itemState.count);
                }
            }
            i.stream.setNoflush(i.stream.size() - 1, (Binding)i.binding, i.current.getSample());
        }
        if (condition) {
            i.itemState.firstValue.readFrom(value.getBinding(), value.getValue());
            i.itemState.firstTime = currentTime;
            i.itemState.currentValue.readFrom(value.getBinding(), value.getValue());
            i.itemState.currentTime = currentTime;
            i.itemState.isNaN = isNanValue;
            i.itemState.isValid = isValidValue;
            i.itemState.sum = 0.0;
            i.itemState.count = 1;
            i.itemState.ooDeadband = false;
            if (i.itemState.median != null) {
                i.itemState.median.clear();
                if (!Double.isNaN(prevValueDouble)) {
                    double deltaTime = currentTime - prevTime;
                    i.itemState.median.add(deltaTime, prevValueDouble);
                }
            }
            i.current.reset();
            i.current.setTime(time.getBinding(), time.getValue());
            if (i.current.hasEndTime()) {
                i.current.setEndTime(time.getBinding(), time.getValue());
            }
            if (isValidValue) {
                i.current.setValue(value.getBinding(), value.getValue());
                i.current.setMax(value.getBinding(), value.getValue());
                i.current.setMin(value.getBinding(), value.getValue());
                i.current.setLastValue(value.getBinding(), value.getValue());
                i.current.setAvg(value.getBinding(), value.getValue());
                i.current.setMedian(value.getBinding(), value.getValue());
            } else {
                i.current.setValueNull();
            }
            if (i.current.hasCount()) {
                i.current.setCount(1);
            }
            i.stream.addNoflush((Binding)i.binding, i.current.getSample());
        }
    }

    @Override
    public void flush() {
        for (ActiveStream i : this.items) {
            try {
                i.stream.flush();
            }
            catch (AccessorException e) {
                logger.log(Level.FINE, "File history flush failed.", e);
            }
        }
    }

    public void flush(Set<String> ids) {
        for (ActiveStream i : this.items) {
            if (!ids.contains(i.itemState.id)) continue;
            try {
                i.stream.flush();
            }
            catch (AccessorException e) {
                logger.log(Level.FINE, "File history flush failed.", e);
            }
        }
    }

    @Override
    public synchronized void close() {
        ArrayList<Bean> beans = new ArrayList<Bean>(this.state.itemStates.size());
        for (CollectorState.Item itemState : this.state.itemStates.values()) {
            try {
                if (!this.history.exists(itemState.id)) continue;
                Bean bean = this.history.getItem(itemState.id);
                bean.readAvailableFields((Bean)itemState);
                beans.add(CollectorImpl.setItemState(bean, itemState));
            }
            catch (BindingException e) {
                logger.log(Level.FINE, "Error writing a meta-data to history", e);
            }
            catch (BindingConstructionException e) {
                logger.log(Level.FINE, "Error writing a meta-data to history", e);
            }
            catch (HistoryException e) {
                logger.log(Level.FINE, "Error writing a meta-data to history", e);
            }
        }
        try {
            this.history.modify(beans.toArray(new Bean[beans.size()]));
        }
        catch (HistoryException e) {
            logger.log(Level.FINE, "Error writing a meta-data to history", e);
        }
        this.state.itemStates.clear();
        for (ActiveStream item : this.items) {
            item.close();
        }
        this.items.clear();
    }

    @Override
    public StreamAccessor openStream(String itemId, String mode) throws HistoryException {
        return this.history.openStream(itemId, mode);
    }

    @Override
    public HistoryManager getHistory() {
        return this.history;
    }

    public class ActiveStream {
        public StreamAccessor stream;
        public RecordBinding binding;
        public Binding valueBinding;
        public boolean isNumeric;
        public boolean hasEndTime;
        public CollectorState.Item itemState;
        public ValueBand current;
        public Adapter valueToDouble;
        public Adapter doubleToValue;

        void close() {
            try {
                if (this.stream != null) {
                    this.stream.close();
                }
                this.stream = null;
            }
            catch (AccessorException e) {
                logger.log(Level.FINE, "Error closing stream", e);
            }
        }
    }

    public static class _HistoryItem
    extends SubscriptionItem {
        public CollectorState.Item collectorState;
    }
}

