package org.simantics.document.ui.function;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.Dependencies;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.FunctionImpl5;
import org.simantics.workbench.search.NameRow;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;
import org.simantics.workbench.search.Searching;

public class SearchFunction extends FunctionImpl5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> {

	@Override
	public SearchResult apply(IProgressMonitor monitor, ReadGraph graph, Resource model, SearchQuery query, Integer maxResults) {
		 try {
			 Collection<Map<String, Object>> results = Searching.performSearch(graph, Layer0X.getInstance(graph).Dependencies, model,
	                    query.escaped(false).getQuery("Name","Types"), maxResults);
	        	return generateSearchResults(graph, results);
	        } catch (DatabaseException e) {
	            Logger.defaultLogError(e);
	        }
	        return null;
	}
	
    public static final SearchResult generateSearchResults(ReadGraph graph,
            Collection<Map<String, Object>> results) throws DatabaseException {
    	Layer0 l0 = Layer0.getInstance(graph);
        DocumentResource doc = DocumentResource.getInstance(graph);

        SearchResult result = new SearchResult(NameRow.columns);
        Set<Resource> processed = new HashSet<Resource>();

        for (Map<String, Object> r : results) {
            Resource resource = (Resource) r.get(Dependencies.FIELD_RESOURCE);

            // Ignore non-documents
            if (!graph.isInstanceOf(resource, doc.Document))
                continue;

           
            // Prevent index corruption from producing duplicate results.
            if (!processed.add(resource))
                continue;

          


            Resource parent = (Resource) r.get(Dependencies.FIELD_PARENT);
            String name = (String) r.get(Dependencies.FIELD_NAME);
            // TODO : hackfix: Sometimes index reports resource as its own parent. 
            if (resource.equals(parent)) {
            	Resource p = graph.getPossibleObject(resource, l0.PartOf);
            	if (p != null)
            		parent = p;
            }

            NameRow rst = new NameRow();
            rst.resource = NamedResource.of(graph, resource, name);
            rst.parent = NamedResource.of(graph, parent);

            result.addRow(rst);
        }
        return result;
    }
	
}

