/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.contribution;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.Activator;
import org.simantics.utils.ui.gfx.DecorationOverlayIcon;

/**
 * @author Tuukka Lehtonen
 */
public class DocumentImageDecorationRule implements ImageDecorationRule {
	
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public ImageDecorator getImageDecorator(ReadGraph graph, Object content) throws DatabaseException {
    	
        DocumentResource DOC = DocumentResource.getInstance(graph);
        if(graph.hasStatement((Resource)content, DOC.HasDocumentation)) {
            return new ImageDecorator() {
                @SuppressWarnings("unchecked")
                @Override
                public <Image> Image decorateImage(Image image, String column, int itemIndex) {
                    return (Image) getDecoration((ImageDescriptor) image);
                }
            };
        }
        
        return null;
        
    }

    private ImageDescriptor getDecoration(ImageDescriptor original) {
        ImageDescriptor img = Activator.getDefault().DOCUMENT_DECORATION_ICON;
        return (original == null) ? img
                : new DecorationOverlayIcon(original, img, IDecoration.BOTTOM_LEFT);
    }

}
