/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.ui.internal;

import org.eclipse.core.runtime.Platform;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.debug.ui.GraphDebuggerView;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;

/**
 * @author Tuukka Lehtonen
 */
public class GraphDebuggerAdapter extends AbstractResourceEditorAdapter {

    public GraphDebuggerAdapter() {
        super("Graph Debugger View", SimanticsUI.getImageDescriptor("icons/etool16/bug.png"));
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) {
        return Platform.inDevelopmentMode();
    }

    @Override
    public void openEditor(Resource r) throws Exception {
        openViewWithId(GraphDebuggerView.VIEW_ID, r);
    }

}
