/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.SessionManagerSource;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.TestSettings;

public class TestHandler {
    private final Driver driver = Manager.getDriver((String)"procore");
    private final File dbFolder;

    TestHandler(TestSettings testSettings, String dbFolderName) throws DatabaseException {
        this.dbFolder = dbFolderName == null ? Platform.getLocation().append("db").toFile() : new File(dbFolderName);
    }

    void initNew() throws DatabaseException {
        Driver.Management m = this.getManagement();
        if (m.exist()) {
            m.delete();
        }
        m.create();
    }

    void initIfNeccessary() throws DatabaseException {
        Driver.Management m = this.getManagement();
        if (!m.exist()) {
            m.create();
        }
    }

    public Session getSession() throws DatabaseException {
        Properties props = new Properties();
        props.setProperty("user", "Default User");
        props.setProperty("password", "");
        return this.driver.getSession(this.dbFolder.getAbsolutePath(), props);
    }

    public ServerI getServer() throws DatabaseException {
        return this.driver.getServer(this.dbFolder.getAbsolutePath(), null);
    }

    public Driver.Management getManagement() throws DatabaseException {
        return this.driver.getManagement(this.dbFolder.getAbsolutePath(), null);
    }

    public Session regSession(long sessionId) throws DatabaseException, IOException {
        SessionManager sm = SessionManagerSource.getSessionManager();
        ProCoreServerReference ser = new ProCoreServerReference(this.dbFolder.toPath());
        ProCoreSessionReference ses = new ProCoreSessionReference(ser, sessionId);
        return sm.createSession((SessionReference)ses, null);
    }
}

