/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.validation;

import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.validation.GetConstraints;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class ValidationUtils {
    public static Set<Issue> validateConstraints(ReadGraph graph, Resource r, Set<Issue> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource constraint : (Set)graph.syncRequest((Read)new GetConstraints(r))) {
            try {
                Resource function = graph.getSingleObject(constraint, L0.Constraint_Validator);
                List issues = (List)Functions.exec((RequestProcessor)graph, (Resource)function, (Object[])new Object[]{graph, r});
                if (issues == null || issues.isEmpty()) continue;
                if (result == null) {
                    result = new THashSet();
                }
                result.addAll(issues);
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
        }
        return result != null ? result : Collections.emptySet();
    }

    public static Set<Issue> validateConstraints(ReadGraph graph, Resource r) throws DatabaseException {
        return ValidationUtils.validateConstraints(graph, r, null);
    }

    public static Set<Issue> validateConstraintsForDomain(ReadGraph graph, Resource r) throws DatabaseException {
        Set<Issue> result = null;
        ModelTransferableGraphSourceRequest.DomainOnlyProcessor dp = ModelTransferableGraphSourceRequest.getDomainOnly((RequestProcessor)graph, null, r);
        for (Map.Entry status : dp.getStatus().entrySet()) {
            Resource rr;
            Set<Issue> issues;
            if (!SubgraphExtent.ExtentStatus.INTERNAL.equals(status.getValue()) || (issues = ValidationUtils.validateConstraints(graph, rr = (Resource)status.getKey(), result)).isEmpty()) continue;
            result = issues;
        }
        return result != null ? result : Collections.emptySet();
    }
}

