/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Collection;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;

public class GraphAccessorUtils {
    public static Accessor create(RequestProcessor rp, Resource resource, Binding binding) throws DatabaseException {
        ValueReadRequest request = new ValueReadRequest(resource, binding);
        ValueReadListener listener = new ValueReadListener(binding);
        rp.syncRequest((Read)request, (Listener)listener);
        try {
            listener.accessor.addListener((Accessor.Listener)new AccessorListener(listener.accessor, rp, resource, binding), InterestSet.newInterestSet((Datatype)listener.accessor.type(), (boolean)true, (boolean)false, (boolean)true), null, null);
        }
        catch (AccessorException e) {
            e.printStackTrace();
        }
        return listener.accessor;
    }

    public static Accessor create(RequestProcessor rp, Resource resource, Resource relation, Object defaultValue, Binding binding) throws DatabaseException {
        ValueReadRequest2 request = new ValueReadRequest2(resource, relation, defaultValue, binding);
        ValueReadListener listener = new ValueReadListener(binding);
        rp.syncRequest((Read)request, (Listener)listener);
        try {
            listener.accessor.addListener((Accessor.Listener)new AccessorListener2(listener.accessor, rp, resource, relation, binding), InterestSet.newInterestSet((Datatype)listener.accessor.type(), (boolean)true, (boolean)false, (boolean)true), null, null);
        }
        catch (AccessorException e) {
            e.printStackTrace();
        }
        return listener.accessor;
    }

    private static class AccessorListener
    implements Accessor.Listener {
        Accessor accessor;
        RequestProcessor rp;
        Resource resource;
        Binding binding;

        public AccessorListener(Accessor accessor, RequestProcessor rp, Resource resource, Binding binding) {
            this.accessor = accessor;
            this.rp = rp;
            this.resource = resource;
            this.binding = binding;
        }

        public void onEvents(Collection<Event> event) {
            this.rp.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    try {
                        Object a = accessor.getValue(binding);
                        Object b = graph.getValue(resource, binding);
                        if (!binding.equals(a, b)) {
                            graph.claimValue(resource, a, binding);
                        }
                    }
                    catch (AccessorException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            });
        }
    }

    private static class AccessorListener2
    implements Accessor.Listener {
        Accessor accessor;
        RequestProcessor rp;
        Resource resource;
        Resource relation;
        Binding binding;

        public AccessorListener2(Accessor accessor, RequestProcessor rp, Resource resource, Resource relation, Binding binding) {
            this.accessor = accessor;
            this.rp = rp;
            this.resource = resource;
            this.relation = relation;
            this.binding = binding;
        }

        public void onEvents(Collection<Event> event) {
            this.rp.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    try {
                        Object a = accessor.getValue(binding);
                        Resource valueResource = graph.getPossibleObject(resource, relation);
                        if (valueResource == null) {
                            valueResource = graph.newResource();
                            graph.claim(resource, relation, valueResource);
                            graph.claimValue(valueResource, a, binding);
                        } else {
                            Object b = graph.getValue(valueResource, binding);
                            if (!binding.equals(a, b)) {
                                graph.claimLiteral(resource, relation, a, binding);
                            }
                        }
                    }
                    catch (AccessorException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            });
        }
    }

    private static class ValueReadListener
    implements Listener<Object> {
        Binding binding;
        Accessor accessor;

        public ValueReadListener(Binding binding) {
            this.binding = binding;
        }

        public void exception(Throwable t) {
        }

        public void execute(Object result) {
            if (this.accessor == null) {
                try {
                    this.accessor = Accessors.getAccessor((Binding)this.binding, (Object)result);
                }
                catch (AccessorConstructionException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (!this.binding.equals(this.accessor.getValue(this.binding), result)) {
                        this.accessor.setValue(this.binding, result);
                    }
                }
                catch (AccessorException e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean isDisposed() {
            return false;
        }
    }

    private static class ValueReadRequest
    implements Read<Object> {
        Resource resource;
        Binding binding;

        public ValueReadRequest(Resource resource, Binding binding) {
            this.resource = resource;
            this.binding = binding;
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            return graph.getValue(this.resource, this.binding);
        }
    }

    private static class ValueReadRequest2
    implements Read<Object> {
        Resource resource;
        Resource relation;
        Object defaultValue;
        Binding binding;

        public ValueReadRequest2(Resource resource, Resource relation, Object defaultValue, Binding binding) {
            this.resource = resource;
            this.relation = relation;
            this.defaultValue = defaultValue;
            this.binding = binding;
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            Object value = graph.getPossibleRelatedValue(this.resource, this.relation, this.binding);
            if (value != null) {
                return value;
            }
            return this.defaultValue;
        }
    }
}

