package org.simantics.datatypes.conversion;

import org.simantics.datatypes.adt.Color;
import org.simantics.datatypes.literal.RGB;

public class RGBIntegerColorAdapter implements Color {
	
    public RGB.Integer rgb;
    
	@Override
	public double getR() {
		return (1.0/512.0) + (1.0/256.0) * (double)rgb.red;
	}
	
	@Override
	public double getG() {
		return (1.0/512.0) + (1.0/256.0) * (double)rgb.green;
	}
	
	@Override
	public double getB() {
		return (1.0/512.0) + (1.0/256.0) * (double)rgb.blue;
	}
	
	@Override
	public double getA() {
		return 0;
	}
	
	@Override
	public double getH() {
		return 0;
	}
	
	@Override
	public double getS() {
		return 0;
	}
	
	@Override
	public double getV() {
		return 0;
	}
	
}